/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.core.CoreGraphDatabase;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.causalclustering.readreplica.ReadReplicaGraphDatabase;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.impl.FileIsNotMappedException;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCursor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.test.assertion.Assert;
import org.neo4j.test.causalclustering.ClusterRule;

public class VersionContextTrackingIT {
    @Rule
    public final ClusterRule clusterRule = new ClusterRule();
    private static final int NUMBER_OF_TRANSACTIONS = 3;
    private Cluster cluster;

    @Before
    public void setup() throws Exception {
        this.cluster = this.clusterRule.withSharedCoreParam(GraphDatabaseSettings.snapshot_query, "true").withSharedReadReplicaParam(GraphDatabaseSettings.snapshot_query, "true").startCluster();
    }

    @Test
    public void coreMemberTransactionIdPageTracking() throws Exception {
        long baseTxId = this.getBaseTransactionId();
        for (int i = 1; i < 4; ++i) {
            this.generateData();
            long expectedLatestPageVersion = this.getExpectedLatestPageVersion(baseTxId, i);
            ThrowingSupplier anyCoreSupplier = () -> VersionContextTrackingIT.getLatestPageVersion((GraphDatabaseFacade)this.getAnyCore());
            Assert.assertEventually((String)"Any core page version should match to expected page version.", (ThrowingSupplier)anyCoreSupplier, (Matcher)Is.is((Object)expectedLatestPageVersion), (long)2L, (TimeUnit)TimeUnit.MINUTES);
        }
    }

    @Test
    public void readReplicatesTransactionIdPageTracking() throws Exception {
        long baseTxId = this.getBaseTransactionId();
        for (int i = 1; i < 4; ++i) {
            this.generateData();
            long expectedLatestPageVersion = this.getExpectedLatestPageVersion(baseTxId, i);
            ThrowingSupplier replicateVersionSupplier = () -> VersionContextTrackingIT.getLatestPageVersion((GraphDatabaseFacade)this.getAnyReadReplica());
            Assert.assertEventually((String)"Read replica page version should match to core page version.", (ThrowingSupplier)replicateVersionSupplier, (Matcher)Is.is((Object)expectedLatestPageVersion), (long)2L, (TimeUnit)TimeUnit.MINUTES);
        }
    }

    private long getExpectedLatestPageVersion(long baseTxId, int round) {
        return baseTxId + (long)(round * 3);
    }

    private long getBaseTransactionId() {
        DependencyResolver dependencyResolver = this.getAnyCore().getDependencyResolver();
        TransactionIdStore transactionIdStore = (TransactionIdStore)dependencyResolver.resolveDependency(TransactionIdStore.class);
        return transactionIdStore.getLastClosedTransactionId();
    }

    private CoreClusterMember anyCoreClusterMember() {
        return this.cluster.coreMembers().iterator().next();
    }

    private CoreGraphDatabase getAnyCore() {
        return this.anyCoreClusterMember().database();
    }

    private ReadReplicaGraphDatabase getAnyReadReplica() {
        return this.cluster.findAnyReadReplica().database();
    }

    private static long getLatestPageVersion(GraphDatabaseFacade databaseFacade) throws IOException {
        DependencyResolver dependencyResolver = databaseFacade.getDependencyResolver();
        PageCache pageCache = (PageCache)dependencyResolver.resolveDependency(PageCache.class);
        NeoStores neoStores = ((RecordStorageEngine)dependencyResolver.resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
        File storeFile = neoStores.getNodeStore().getStorageFileName();
        long maxTransactionId = Long.MIN_VALUE;
        try (PagedFile pageFile = (PagedFile)pageCache.getExistingMapping(storeFile).get();){
            long lastPageId = pageFile.getLastPageId();
            int i = 0;
            while ((long)i <= lastPageId) {
                try (CursorPageAccessor pageCursor = new CursorPageAccessor((MuninnPageCursor)pageFile.io((long)i, 1));){
                    if (pageCursor.next()) {
                        maxTransactionId = Math.max(maxTransactionId, pageCursor.lastTxModifierId());
                    }
                }
                ++i;
            }
        }
        return maxTransactionId;
    }

    private void generateData() throws Exception {
        for (int i = 0; i < 3; ++i) {
            this.cluster.coreTx((coreGraphDatabase, transaction) -> {
                coreGraphDatabase.createNode();
                transaction.success();
            });
        }
    }

    private static class CursorPageAccessor
    extends MuninnPageCursor {
        private MuninnPageCursor delegate;

        CursorPageAccessor(MuninnPageCursor delegate) {
            super(-1L, PageCursorTracer.NULL, EmptyVersionContextSupplier.EMPTY);
            this.delegate = delegate;
        }

        long lastTxModifierId() {
            return this.delegate.pagedFile.getLastModifiedTxId(this.delegate.pinnedPageRef);
        }

        protected void unpinCurrentPage() {
            this.delegate.unpinCurrentPage();
        }

        protected void convertPageFaultLock(long pageRef) {
            this.delegate.convertPageFaultLock(pageRef);
        }

        protected void pinCursorToPage(long pageRef, long filePageId, PageSwapper swapper) throws FileIsNotMappedException {
            this.delegate.pinCursorToPage(pageRef, filePageId, swapper);
        }

        protected boolean tryLockPage(long pageRef) {
            return this.delegate.tryLockPage(pageRef);
        }

        protected void unlockPage(long pageRef) {
            this.delegate.unlockPage(pageRef);
        }

        protected void releaseCursor() {
            this.delegate.releaseCursor();
        }

        public boolean next() throws IOException {
            return this.delegate.next();
        }

        public boolean shouldRetry() throws IOException {
            return this.delegate.shouldRetry();
        }
    }
}

