/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.matchers;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;

public final class Matchers {
    private Matchers() {
    }

    public static Matcher<? super List<RaftMessages.RaftMessage>> hasMessage(final RaftMessages.BaseRaftMessage message) {
        return new TypeSafeMatcher<List<RaftMessages.RaftMessage>>(){

            protected boolean matchesSafely(List<RaftMessages.RaftMessage> messages) {
                return messages.contains(message);
            }

            public void describeTo(Description description) {
                description.appendText("has message " + message);
            }
        };
    }

    public static Matcher<? super List<RaftMessages.RaftMessage>> hasRaftLogEntries(final Collection<RaftLogEntry> expectedEntries) {
        return new TypeSafeMatcher<List<RaftMessages.RaftMessage>>(){

            protected boolean matchesSafely(List<RaftMessages.RaftMessage> messages) {
                List entries = messages.stream().filter(message -> message instanceof RaftMessages.AppendEntries.Request).map(m -> (RaftMessages.AppendEntries.Request)m).flatMap(x -> Arrays.stream(x.entries())).collect(Collectors.toList());
                return entries.containsAll(expectedEntries);
            }

            public void describeTo(Description description) {
                description.appendText("log entries " + expectedEntries);
            }
        };
    }
}

