/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster;

import java.net.URI;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.ExecutorLifecycleAdapter;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.ProtocolServer;
import org.neo4j.cluster.ProtocolServerFactory;
import org.neo4j.cluster.com.NetworkReceiver;
import org.neo4j.cluster.com.NetworkSender;
import org.neo4j.cluster.protocol.atomicbroadcast.AtomicBroadcastSerializer;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectInputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectOutputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.AcceptorInstanceStore;
import org.neo4j.cluster.protocol.election.ElectionCredentialsProvider;
import org.neo4j.cluster.statemachine.StateTransitionLogger;
import org.neo4j.cluster.timeout.TimeoutStrategy;
import org.neo4j.function.Factory;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.NamedThreadFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.LogProvider;

public class NetworkedServerFactory {
    private LifeSupport life;
    private ProtocolServerFactory protocolServerFactory;
    private TimeoutStrategy timeoutStrategy;
    private final NetworkReceiver.Monitor networkReceiverMonitor;
    private final NetworkSender.Monitor networkSenderMonitor;
    private LogProvider logProvider;
    private ObjectInputStreamFactory objectInputStreamFactory;
    private ObjectOutputStreamFactory objectOutputStreamFactory;
    private final NamedThreadFactory.Monitor namedThreadFactoryMonitor;

    public NetworkedServerFactory(LifeSupport life, ProtocolServerFactory protocolServerFactory, TimeoutStrategy timeoutStrategy, LogProvider logProvider, ObjectInputStreamFactory objectInputStreamFactory, ObjectOutputStreamFactory objectOutputStreamFactory, NetworkReceiver.Monitor networkReceiverMonitor, NetworkSender.Monitor networkSenderMonitor, NamedThreadFactory.Monitor namedThreadFactoryMonitor) {
        this.life = life;
        this.protocolServerFactory = protocolServerFactory;
        this.timeoutStrategy = timeoutStrategy;
        this.networkReceiverMonitor = networkReceiverMonitor;
        this.networkSenderMonitor = networkSenderMonitor;
        this.logProvider = logProvider;
        this.objectInputStreamFactory = objectInputStreamFactory;
        this.objectOutputStreamFactory = objectOutputStreamFactory;
        this.namedThreadFactoryMonitor = namedThreadFactoryMonitor;
    }

    public ProtocolServer newNetworkedServer(final Config config, AcceptorInstanceStore acceptorInstanceStore, ElectionCredentialsProvider electionCredentialsProvider) {
        NetworkReceiver receiver = new NetworkReceiver(this.networkReceiverMonitor, new NetworkReceiver.Configuration(){

            @Override
            public HostnamePort clusterServer() {
                return (HostnamePort)config.get(ClusterSettings.cluster_server);
            }

            @Override
            public int defaultPort() {
                return 5001;
            }

            @Override
            public String name() {
                return null;
            }
        }, this.logProvider);
        NetworkSender sender = new NetworkSender(this.networkSenderMonitor, new NetworkSender.Configuration(){

            @Override
            public int defaultPort() {
                return 5001;
            }

            @Override
            public int port() {
                return ((HostnamePort)config.get(ClusterSettings.cluster_server)).getPort();
            }
        }, receiver, this.logProvider);
        ExecutorLifecycleAdapter stateMachineExecutor = new ExecutorLifecycleAdapter((Factory<ExecutorService>)((Factory)() -> Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("State machine", this.namedThreadFactoryMonitor))));
        final ProtocolServer protocolServer = this.protocolServerFactory.newProtocolServer((InstanceId)config.get(ClusterSettings.server_id), this.timeoutStrategy, receiver, sender, acceptorInstanceStore, electionCredentialsProvider, stateMachineExecutor, this.objectInputStreamFactory, this.objectOutputStreamFactory, config);
        receiver.addNetworkChannelsListener(new NetworkReceiver.NetworkChannelsListener(){
            private StateTransitionLogger logger;

            @Override
            public void listeningAt(URI me) {
                protocolServer.listeningAt(me);
                if (this.logger == null) {
                    this.logger = new StateTransitionLogger(NetworkedServerFactory.this.logProvider, new AtomicBroadcastSerializer(NetworkedServerFactory.this.objectInputStreamFactory, NetworkedServerFactory.this.objectOutputStreamFactory));
                    protocolServer.addStateTransitionListener(this.logger);
                }
            }

            @Override
            public void channelOpened(URI to) {
            }

            @Override
            public void channelClosed(URI to) {
            }
        });
        this.life.add((Lifecycle)stateMachineExecutor);
        this.life.add(new Lifecycle(){
            private ScheduledExecutorService scheduler;

            public void init() {
                protocolServer.getTimeouts().tick(System.currentTimeMillis());
            }

            public void start() {
                this.scheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("timeout"));
                this.scheduler.scheduleWithFixedDelay(() -> {
                    long now = System.currentTimeMillis();
                    protocolServer.getTimeouts().tick(now);
                }, 0L, 10L, TimeUnit.MILLISECONDS);
            }

            public void stop() {
                this.scheduler.shutdownNow();
            }

            public void shutdown() {
            }
        });
        this.life.add((Lifecycle)sender);
        this.life.add((Lifecycle)receiver);
        return protocolServer;
    }
}

