/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigurationValidator;
import org.neo4j.kernel.impl.enterprise.configuration.EnterpriseEditionSettings;
import org.neo4j.logging.Log;

public class HaConfigurationValidator
implements ConfigurationValidator {
    public Map<String, String> validate(@Nonnull Config config, @Nonnull Log log) throws InvalidSettingException {
        EnterpriseEditionSettings.Mode mode = (EnterpriseEditionSettings.Mode)config.get(EnterpriseEditionSettings.mode);
        if (mode.equals((Object)EnterpriseEditionSettings.Mode.HA) || mode.equals((Object)EnterpriseEditionSettings.Mode.ARBITER)) {
            HaConfigurationValidator.validateServerId(config);
            HaConfigurationValidator.validateInitialHosts(config);
        }
        return Collections.emptyMap();
    }

    private static void validateServerId(Config config) {
        if (!config.isConfigured(ClusterSettings.server_id)) {
            throw new InvalidSettingException(String.format("Missing mandatory value for '%s'", ClusterSettings.server_id.name()));
        }
    }

    private static void validateInitialHosts(Config config) {
        List hosts = (List)config.get(ClusterSettings.initial_hosts);
        if (hosts == null || hosts.isEmpty()) {
            throw new InvalidSettingException(String.format("Missing mandatory non-empty value for '%s'", ClusterSettings.initial_hosts.name()));
        }
    }
}

