/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import org.neo4j.com.ChannelContext;
import org.neo4j.com.ResourcePool;
import org.neo4j.logging.Log;

public class LoggingResourcePoolMonitor
extends ResourcePool.Monitor.Adapter<ChannelContext> {
    private final Log msgLog;
    private int lastCurrentPeakSize = -1;
    private int lastTargetSize = -1;

    public LoggingResourcePoolMonitor(Log msgLog) {
        this.msgLog = msgLog;
    }

    @Override
    public void updatedCurrentPeakSize(int currentPeakSize) {
        if (this.lastCurrentPeakSize != currentPeakSize) {
            this.msgLog.debug("ResourcePool updated currentPeakSize to " + currentPeakSize);
            this.lastCurrentPeakSize = currentPeakSize;
        }
    }

    @Override
    public void created(ChannelContext resource) {
        this.msgLog.debug("ResourcePool create resource " + resource);
    }

    @Override
    public void updatedTargetSize(int targetSize) {
        if (this.lastTargetSize != targetSize) {
            this.msgLog.debug("ResourcePool updated targetSize to " + targetSize);
            this.lastTargetSize = targetSize;
        }
    }
}

