/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.LengthFieldPrepender;
import org.jboss.netty.handler.queue.BlockingReadHandler;
import org.neo4j.com.BlockLogReader;
import org.neo4j.com.ChunkingChannelBuffer;
import org.neo4j.com.ComException;
import org.neo4j.com.DechunkingChannelBuffer;
import org.neo4j.com.Deserializer;
import org.neo4j.com.NetworkFlushableChannel;
import org.neo4j.com.NetworkReadableClosableChannel;
import org.neo4j.com.ObjectSerializer;
import org.neo4j.com.RequestContext;
import org.neo4j.com.RequestType;
import org.neo4j.com.ResourceReleaser;
import org.neo4j.com.Response;
import org.neo4j.com.Serializer;
import org.neo4j.com.TransactionObligationResponse;
import org.neo4j.com.TransactionStream;
import org.neo4j.com.TransactionStreamResponse;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.storageengine.api.StorageCommand;

public abstract class Protocol {
    public static final int MEGA = 0x100000;
    public static final int DEFAULT_FRAME_LENGTH = 0x1000000;
    public static final ObjectSerializer<Integer> INTEGER_SERIALIZER = (responseObject, result) -> result.writeInt(responseObject.intValue());
    public static final ObjectSerializer<Long> LONG_SERIALIZER = (responseObject, result) -> result.writeLong(responseObject.longValue());
    public static final ObjectSerializer<Void> VOID_SERIALIZER = (responseObject, result) -> {};
    public static final Deserializer<Integer> INTEGER_DESERIALIZER = (buffer, temporaryBuffer) -> buffer.readInt();
    public static final Deserializer<Void> VOID_DESERIALIZER = (buffer, temporaryBuffer) -> null;
    public static final Serializer EMPTY_SERIALIZER = buffer -> {};
    private final int chunkSize;
    private final byte applicationProtocolVersion;
    private final byte internalProtocolVersion;

    public Protocol(int chunkSize, byte applicationProtocolVersion, byte internalProtocolVersion) {
        this.chunkSize = chunkSize;
        this.applicationProtocolVersion = applicationProtocolVersion;
        this.internalProtocolVersion = internalProtocolVersion;
    }

    public static void addLengthFieldPipes(ChannelPipeline pipeline, int frameLength) {
        pipeline.addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(frameLength + 4, 0, 4, 0, 4));
        pipeline.addLast("frameEncoder", (ChannelHandler)new LengthFieldPrepender(4));
    }

    public static void writeString(ChannelBuffer buffer, String name) {
        char[] chars = name.toCharArray();
        buffer.writeInt(chars.length);
        Protocol.writeChars(buffer, chars);
    }

    public static void writeChars(ChannelBuffer buffer, char[] chars) {
        for (char ch : chars) {
            buffer.writeChar((int)ch);
        }
    }

    public static String readString(ChannelBuffer buffer) {
        return Protocol.readString(buffer, buffer.readInt());
    }

    public static boolean readBoolean(ChannelBuffer buffer) {
        byte value = buffer.readByte();
        switch (value) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        throw new ComException("Invalid boolean value " + value);
    }

    public static String readString(ChannelBuffer buffer, int length) {
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = buffer.readChar();
        }
        return new String(chars);
    }

    public static void assertChunkSizeIsWithinFrameSize(int chunkSize, int frameLength) {
        if (chunkSize > frameLength) {
            throw new IllegalArgumentException("Chunk size " + chunkSize + " needs to be equal or less than frame length " + frameLength);
        }
    }

    public void serializeRequest(Channel channel, ChannelBuffer buffer, RequestType type, RequestContext ctx, Serializer payload) throws IOException {
        buffer.clear();
        ChunkingChannelBuffer chunkingBuffer = new ChunkingChannelBuffer(buffer, channel, this.chunkSize, this.internalProtocolVersion, this.applicationProtocolVersion);
        chunkingBuffer.writeByte(type.id());
        this.writeContext(ctx, chunkingBuffer);
        payload.write(chunkingBuffer);
        chunkingBuffer.done();
    }

    public <PAYLOAD> Response<PAYLOAD> deserializeResponse(BlockingReadHandler<ChannelBuffer> reader, ByteBuffer input, long timeout, Deserializer<PAYLOAD> payloadDeserializer, ResourceReleaser channelReleaser, LogEntryReader<ReadableClosablePositionAwareChannel> entryReader) throws IOException {
        DechunkingChannelBuffer dechunkingBuffer = new DechunkingChannelBuffer(reader, timeout, this.internalProtocolVersion, this.applicationProtocolVersion);
        PAYLOAD response = payloadDeserializer.read(dechunkingBuffer, input);
        StoreId storeId = this.readStoreId(dechunkingBuffer, input);
        byte responseType = dechunkingBuffer.readByte();
        if (responseType == -1) {
            long obligationTxId = dechunkingBuffer.readLong();
            return new TransactionObligationResponse<PAYLOAD>(response, storeId, obligationTxId, channelReleaser);
        }
        TransactionStream transactions = visitor -> {
            NetworkReadableClosableChannel channel = new NetworkReadableClosableChannel(dechunkingBuffer);
            try (PhysicalTransactionCursor cursor = new PhysicalTransactionCursor((ReadableClosablePositionAwareChannel)channel, entryReader);){
                while (cursor.next() && !visitor.visit((Object)cursor.get())) {
                }
            }
        };
        return new TransactionStreamResponse<PAYLOAD>(response, storeId, transactions, channelReleaser);
    }

    protected abstract StoreId readStoreId(ChannelBuffer var1, ByteBuffer var2);

    private void writeContext(RequestContext context, ChannelBuffer targetBuffer) {
        targetBuffer.writeLong(context.getEpoch());
        targetBuffer.writeInt(context.machineId());
        targetBuffer.writeInt(context.getEventIdentifier());
        long tx = context.lastAppliedTransaction();
        targetBuffer.writeLong(tx);
        targetBuffer.writeLong(context.getChecksum());
    }

    public static class TransactionSerializer
    implements Serializer {
        private final TransactionRepresentation tx;

        public TransactionSerializer(TransactionRepresentation tx) {
            this.tx = tx;
        }

        @Override
        public void write(ChannelBuffer buffer) throws IOException {
            NetworkFlushableChannel channel = new NetworkFlushableChannel(buffer);
            Protocol.writeString(buffer, "nioneodb");
            channel.putInt(this.tx.getAuthorId());
            channel.putInt(this.tx.getMasterId());
            channel.putLong(this.tx.getLatestCommittedTxWhenStarted());
            channel.putLong(this.tx.getTimeStarted());
            channel.putLong(this.tx.getTimeCommitted());
            channel.putInt(this.tx.additionalHeader().length);
            channel.put(this.tx.additionalHeader(), this.tx.additionalHeader().length);
            new LogEntryWriter((FlushableChannel)channel).serialize(this.tx);
        }
    }

    public static class FileStreamsDeserializer310
    implements Deserializer<Void> {
        private final StoreWriter writer;

        public FileStreamsDeserializer310(StoreWriter writer) {
            this.writer = writer;
        }

        @Override
        public Void read(ChannelBuffer buffer, ByteBuffer temporaryBuffer) throws IOException {
            int pathLength;
            while (0 != (pathLength = buffer.readUnsignedShort())) {
                String path = Protocol.readString(buffer, pathLength);
                boolean hasData = buffer.readByte() == 1;
                int recordSize = hasData ? buffer.readInt() : 1;
                this.writer.write(path, hasData ? new BlockLogReader(buffer) : null, temporaryBuffer, hasData, recordSize);
            }
            this.writer.close();
            return null;
        }
    }

    public static class FileStreamsDeserializer210
    implements Deserializer<Void> {
        private final StoreWriter writer;

        public FileStreamsDeserializer210(StoreWriter writer) {
            this.writer = writer;
        }

        @Override
        public Void read(ChannelBuffer buffer, ByteBuffer temporaryBuffer) throws IOException {
            int pathLength;
            while (0 != (pathLength = buffer.readUnsignedShort())) {
                String path = Protocol.readString(buffer, pathLength);
                boolean hasData = buffer.readByte() == 1;
                this.writer.write(path, hasData ? new BlockLogReader(buffer) : null, temporaryBuffer, hasData, 1);
            }
            this.writer.close();
            return null;
        }
    }

    public static class TransactionRepresentationDeserializer
    implements Deserializer<TransactionRepresentation> {
        private final LogEntryReader<ReadableClosablePositionAwareChannel> reader;

        public TransactionRepresentationDeserializer(LogEntryReader<ReadableClosablePositionAwareChannel> reader) {
            this.reader = reader;
        }

        @Override
        public TransactionRepresentation read(ChannelBuffer buffer, ByteBuffer temporaryBuffer) throws IOException {
            LogEntryCommand entryRead;
            NetworkReadableClosableChannel channel = new NetworkReadableClosableChannel(buffer);
            int authorId = channel.getInt();
            int masterId = channel.getInt();
            long latestCommittedTxWhenStarted = channel.getLong();
            long timeStarted = channel.getLong();
            long timeCommitted = channel.getLong();
            int headerLength = channel.getInt();
            byte[] header = new byte[headerLength];
            channel.get(header, headerLength);
            LinkedList<StorageCommand> commands = new LinkedList<StorageCommand>();
            while ((entryRead = (LogEntryCommand)this.reader.readLogEntry((ReadableClosablePositionAwareChannel)channel)) != null) {
                commands.add(entryRead.getCommand());
            }
            PhysicalTransactionRepresentation toReturn = new PhysicalTransactionRepresentation(commands);
            toReturn.setHeader(header, masterId, authorId, timeStarted, latestCommittedTxWhenStarted, timeCommitted, -1);
            return toReturn;
        }
    }
}

