/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.enterprise.configuration;

import java.util.function.Function;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.LoadableConfig;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.configuration.Settings;

@Description(value="Online backup configuration settings")
public class OnlineBackupSettings
implements LoadableConfig {
    @Description(value="Enable support for running online backups")
    public static final Setting<Boolean> online_backup_enabled = Settings.setting((String)"dbms.backup.enabled", (Function)Settings.BOOLEAN, (String)"true");
    @Description(value="Listening server for online backups. The protocol running varies depending on deployment. In a Causal Clustering environment this is the same protocol that runs on causal_clustering.transaction_listen_address. The port range is only respected in a HA or single instance deployment. In Causal Clustering a single port should be used")
    public static final Setting<HostnamePort> online_backup_server = Settings.setting((String)"dbms.backup.address", (Function)Settings.HOSTNAME_PORT, (String)"127.0.0.1:6362-6372");
    @Description(value="Name of the SSL policy to be used by backup, as defined under the dbms.ssl.policy.* settings. If no policy is configured then the communication will not be secured.")
    public static final Setting<String> ssl_policy = Settings.prefixSetting((String)"dbms.backup.ssl_policy", (Function)Settings.STRING, (String)Settings.NO_DEFAULT);
}

