/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.enterprise.transaction.log.checkpoint;

import java.io.Flushable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import java.util.function.ObjLongConsumer;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.configuration.Config;

public class ConfigurableIOLimiter
implements IOLimiter {
    private static final AtomicLongFieldUpdater<ConfigurableIOLimiter> stateUpdater = AtomicLongFieldUpdater.newUpdater(ConfigurableIOLimiter.class, "state");
    private static final int NO_LIMIT = 0;
    private static final int QUANTUM_MILLIS = 100;
    private static final int TIME_BITS = 32;
    private static final long TIME_MASK = 0xFFFFFFFFL;
    private static final int QUANTUMS_PER_SECOND = (int)(TimeUnit.SECONDS.toMillis(1L) / 100L);
    private final ObjLongConsumer<Object> pauseNanos;
    private volatile long state;

    public ConfigurableIOLimiter(Config config) {
        this(config, LockSupport::parkNanos);
    }

    ConfigurableIOLimiter(Config config, ObjLongConsumer<Object> pauseNanos) {
        this.pauseNanos = pauseNanos;
        Integer iops = (Integer)config.get(GraphDatabaseSettings.check_point_iops_limit);
        this.updateConfiguration(iops);
        config.registerDynamicUpdateListener(GraphDatabaseSettings.check_point_iops_limit, (prev, update) -> this.updateConfiguration((Integer)update));
    }

    private void updateConfiguration(Integer iops) {
        if (iops == null || iops < 1) {
            long newState;
            long oldState;
            do {
                oldState = stateUpdater.get(this);
                int disabledCounter = this.getDisabledCounter(oldState);
            } while (!stateUpdater.compareAndSet(this, oldState, newState = this.composeState(disabledCounter |= 1, 0)));
        } else {
            int iopq;
            long newState;
            long oldState;
            do {
                oldState = stateUpdater.get(this);
                int disabledCounter = this.getDisabledCounter(oldState);
            } while (!stateUpdater.compareAndSet(this, oldState, newState = this.composeState(disabledCounter &= 0xFFFFFFFE, iopq = iops / QUANTUMS_PER_SECOND)));
        }
    }

    private long composeState(int disabledCounter, int iopq) {
        return (long)disabledCounter << 32 | (long)iopq;
    }

    private int getIOPQ(long state) {
        return (int)(state & 0xFFFFFFFFL);
    }

    private int getDisabledCounter(long state) {
        return (int)(state >>> 32);
    }

    public long maybeLimitIO(long previousStamp, int recentlyCompletedIOs, Flushable flushable) {
        long then;
        long state = stateUpdater.get(this);
        if (this.getDisabledCounter(state) > 0) {
            return 0L;
        }
        long now = this.currentTimeMillis() & 0xFFFFFFFFL;
        if (now - (then = previousStamp & 0xFFFFFFFFL) > 100L) {
            return now + ((long)recentlyCompletedIOs << 32);
        }
        long ioSum = (previousStamp >> 32) + (long)recentlyCompletedIOs;
        if (ioSum >= (long)this.getIOPQ(state)) {
            long millisLeftInQuantum = 100L - (now - then);
            this.pauseNanos.accept(this, TimeUnit.MILLISECONDS.toNanos(millisLeftInQuantum));
            return this.currentTimeMillis() & 0xFFFFFFFFL;
        }
        return then + (ioSum << 32);
    }

    public void disableLimit() {
        int disabledCounter;
        long newState;
        long currentState;
        while (!stateUpdater.compareAndSet(this, currentState = stateUpdater.get(this), newState = this.composeState(disabledCounter = this.getDisabledCounter(currentState) + 2, this.getIOPQ(currentState)))) {
        }
    }

    public void enableLimit() {
        int disabledCounter;
        long newState;
        long currentState;
        while (!stateUpdater.compareAndSet(this, currentState = stateUpdater.get(this), newState = this.composeState(disabledCounter = this.getDisabledCounter(currentState) - 2, this.getIOPQ(currentState)))) {
        }
    }

    private long currentTimeMillis() {
        return System.currentTimeMillis();
    }
}

