/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jmx.impl;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.mutable.MutableLong;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.jmx.StoreSize;
import org.neo4j.jmx.impl.ManagementBeanProvider;
import org.neo4j.jmx.impl.ManagementData;
import org.neo4j.jmx.impl.Neo4jMBean;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.api.ExplicitIndexProviderLookup;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.store.StoreFile;
import org.neo4j.kernel.impl.storemigration.StoreFileType;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogVersionVisitor;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.kernel.spi.explicitindex.IndexImplementation;

public final class StoreSizeBean
extends ManagementBeanProvider {
    public StoreSizeBean() {
        super(StoreSize.class);
    }

    @Override
    protected Neo4jMBean createMBean(ManagementData management) {
        return new StoreSizeImpl(management, false);
    }

    @Override
    protected Neo4jMBean createMXBean(ManagementData management) {
        return new StoreSizeImpl(management, true);
    }

    static class StoreSizeImpl
    extends Neo4jMBean
    implements StoreSize {
        private final FileSystemAbstraction fs;
        private final File storePath;
        private LogFiles logFiles;
        private ExplicitIndexProviderLookup explicitIndexProviderLookup;
        private IndexProviderMap indexProviderMap;
        private LabelScanStore labelScanStore;

        StoreSizeImpl(ManagementData management, boolean isMXBean) {
            super(management, isMXBean, new String[0]);
            this.fs = management.getKernelData().getFilesystemAbstraction();
            this.storePath = this.resolveStorePath(management);
            DataSourceManager dataSourceManager = (DataSourceManager)management.resolveDependency(DataSourceManager.class);
            dataSourceManager.addListener(new DataSourceManager.Listener(){

                public void registered(NeoStoreDataSource ds) {
                    logFiles = this.resolveDependency(ds, LogFiles.class);
                    explicitIndexProviderLookup = this.resolveDependency(ds, ExplicitIndexProviderLookup.class);
                    indexProviderMap = this.resolveDependency(ds, IndexProviderMap.class);
                    labelScanStore = this.resolveDependency(ds, LabelScanStore.class);
                }

                private <T> T resolveDependency(NeoStoreDataSource ds, Class<T> clazz) {
                    return (T)ds.getDependencyResolver().resolveDependency(clazz);
                }

                public void unregistered(NeoStoreDataSource ds) {
                    logFiles = null;
                    explicitIndexProviderLookup = null;
                    indexProviderMap = null;
                    labelScanStore = null;
                }
            });
        }

        @Override
        public long getTransactionLogsSize() {
            TotalSizeVersionVisitor logVersionVisitor = new TotalSizeVersionVisitor(this.fs);
            this.logFiles.accept((LogVersionVisitor)logVersionVisitor);
            return logVersionVisitor.getTotalSize();
        }

        @Override
        public long getNodeStoreSize() {
            return this.sizeOfStoreFiles(StoreFile.NODE_STORE, StoreFile.NODE_LABEL_STORE);
        }

        @Override
        public long getRelationshipStoreSize() {
            return this.sizeOfStoreFiles(StoreFile.RELATIONSHIP_STORE, StoreFile.RELATIONSHIP_GROUP_STORE, StoreFile.RELATIONSHIP_TYPE_TOKEN_STORE, StoreFile.RELATIONSHIP_TYPE_TOKEN_NAMES_STORE);
        }

        @Override
        public long getPropertyStoreSize() {
            return this.sizeOfStoreFiles(StoreFile.PROPERTY_STORE, StoreFile.PROPERTY_KEY_TOKEN_STORE, StoreFile.PROPERTY_KEY_TOKEN_NAMES_STORE);
        }

        @Override
        public long getStringStoreSize() {
            return this.sizeOfStoreFiles(StoreFile.PROPERTY_STRING_STORE);
        }

        @Override
        public long getArrayStoreSize() {
            return this.sizeOfStoreFiles(StoreFile.PROPERTY_ARRAY_STORE);
        }

        @Override
        public long getLabelStoreSize() {
            return this.sizeOfStoreFiles(StoreFile.LABEL_TOKEN_STORE, StoreFile.LABEL_TOKEN_NAMES_STORE);
        }

        @Override
        public long getCountStoreSize() {
            return this.sizeOfStoreFiles(StoreFile.COUNTS_STORE_LEFT, StoreFile.COUNTS_STORE_RIGHT);
        }

        @Override
        public long getSchemaStoreSize() {
            return this.sizeOfStoreFiles(StoreFile.SCHEMA_STORE);
        }

        @Override
        public long getIndexStoreSize() {
            long size = 0L;
            for (IndexImplementation index : this.explicitIndexProviderLookup.all()) {
                size += FileUtils.size((FileSystemAbstraction)this.fs, (File)index.getIndexImplementationDirectory(this.storePath));
            }
            MutableLong schemaSize = new MutableLong();
            this.indexProviderMap.accept(provider -> {
                File rootDirectory = provider.directoryStructure().rootDirectory();
                if (rootDirectory != null) {
                    schemaSize.add(FileUtils.size((FileSystemAbstraction)this.fs, (File)rootDirectory));
                }
            });
            size += schemaSize.longValue();
            return size += FileUtils.size((FileSystemAbstraction)this.fs, (File)this.labelScanStore.getLabelScanStoreFile());
        }

        @Override
        public long getTotalStoreSize() {
            return this.storePath == null ? 0L : FileUtils.size((FileSystemAbstraction)this.fs, (File)this.storePath);
        }

        private long sizeOf(String name) {
            return this.storePath == null ? 0L : FileUtils.size((FileSystemAbstraction)this.fs, (File)new File(this.storePath, name));
        }

        private long sizeOfStoreFiles(StoreFile ... files) {
            long size = 0L;
            for (StoreFile file : files) {
                size += this.sizeOf(file.fileName(StoreFileType.STORE));
                if (!file.isRecordStore()) continue;
                size += this.sizeOf(file.fileName(StoreFileType.ID));
            }
            return size;
        }

        private File resolveStorePath(ManagementData management) {
            File storeDir = management.getKernelData().getStoreDir();
            try {
                return storeDir.getCanonicalFile().getAbsoluteFile();
            }
            catch (IOException e) {
                return storeDir.getAbsoluteFile();
            }
        }

        private static class TotalSizeVersionVisitor
        implements LogVersionVisitor {
            private final FileSystemAbstraction fs;
            private long totalSize;

            TotalSizeVersionVisitor(FileSystemAbstraction fs) {
                this.fs = fs;
            }

            long getTotalSize() {
                return this.totalSize;
            }

            public void visit(File file, long logVersion) {
                this.totalSize += FileUtils.size((FileSystemAbstraction)this.fs, (File)file);
            }
        }
    }
}

