/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration.ssl;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ssl.SslPolicyConfig;
import org.neo4j.ssl.ClientAuth;
import org.neo4j.test.rule.TestDirectory;

public class SslPolicyConfigTest {
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();

    @Test
    public void shouldFindPolicyDefaults() {
        Map params = MapUtil.stringMap((String[])new String[0]);
        String policyName = "XYZ";
        SslPolicyConfig policyConfig = new SslPolicyConfig(policyName);
        File homeDir = this.testDirectory.directory("home");
        params.put(GraphDatabaseSettings.neo4j_home.name(), homeDir.getAbsolutePath());
        params.put(policyConfig.base_directory.name(), "certificates/XYZ");
        Config config = Config.defaults((Map)params);
        File privateKey = new File(homeDir, "certificates/XYZ/private.key");
        File publicCertificate = new File(homeDir, "certificates/XYZ/public.crt");
        File trustedDir = new File(homeDir, "certificates/XYZ/trusted");
        File revokedDir = new File(homeDir, "certificates/XYZ/revoked");
        File privateKeyFromConfig = (File)config.get(policyConfig.private_key);
        File publicCertificateFromConfig = (File)config.get(policyConfig.public_certificate);
        File trustedDirFromConfig = (File)config.get(policyConfig.trusted_dir);
        File revokedDirFromConfig = (File)config.get(policyConfig.revoked_dir);
        String privateKeyPassword = (String)config.get(policyConfig.private_key_password);
        boolean allowKeyGeneration = (Boolean)config.get(policyConfig.allow_key_generation);
        boolean trustAll = (Boolean)config.get(policyConfig.trust_all);
        List tlsVersions = (List)config.get(policyConfig.tls_versions);
        List ciphers = (List)config.get(policyConfig.ciphers);
        ClientAuth clientAuth = (ClientAuth)config.get(policyConfig.client_auth);
        Assert.assertEquals((Object)privateKey, (Object)privateKeyFromConfig);
        Assert.assertEquals((Object)publicCertificate, (Object)publicCertificateFromConfig);
        Assert.assertEquals((Object)trustedDir, (Object)trustedDirFromConfig);
        Assert.assertEquals((Object)revokedDir, (Object)revokedDirFromConfig);
        Assert.assertEquals(null, (Object)privateKeyPassword);
        Assert.assertFalse((boolean)allowKeyGeneration);
        Assert.assertFalse((boolean)trustAll);
        Assert.assertEquals(Collections.singletonList("TLSv1.2"), (Object)tlsVersions);
        Assert.assertNull((Object)ciphers);
        Assert.assertEquals((Object)ClientAuth.REQUIRE, (Object)clientAuth);
    }

    @Test
    public void shouldFindPolicyOverrides() {
        Map params = MapUtil.stringMap((String[])new String[0]);
        String policyName = "XYZ";
        SslPolicyConfig policyConfig = new SslPolicyConfig(policyName);
        File homeDir = this.testDirectory.directory("home");
        params.put(GraphDatabaseSettings.neo4j_home.name(), homeDir.getAbsolutePath());
        params.put(policyConfig.base_directory.name(), "certificates/XYZ");
        File privateKey = this.testDirectory.directory("/path/to/my.key");
        File publicCertificate = this.testDirectory.directory("/path/to/my.crt");
        File trustedDir = this.testDirectory.directory("/some/other/path/to/trusted");
        File revokedDir = this.testDirectory.directory("/some/other/path/to/revoked");
        params.put(policyConfig.private_key.name(), privateKey.getAbsolutePath());
        params.put(policyConfig.public_certificate.name(), publicCertificate.getAbsolutePath());
        params.put(policyConfig.trusted_dir.name(), trustedDir.getAbsolutePath());
        params.put(policyConfig.revoked_dir.name(), revokedDir.getAbsolutePath());
        params.put(policyConfig.allow_key_generation.name(), "true");
        params.put(policyConfig.trust_all.name(), "true");
        params.put(policyConfig.private_key_password.name(), "setecastronomy");
        params.put(policyConfig.tls_versions.name(), "TLSv1.1,TLSv1.2");
        params.put(policyConfig.ciphers.name(), "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384");
        params.put(policyConfig.client_auth.name(), "optional");
        Config config = Config.defaults((Map)params);
        File privateKeyFromConfig = (File)config.get(policyConfig.private_key);
        File publicCertificateFromConfig = (File)config.get(policyConfig.public_certificate);
        File trustedDirFromConfig = (File)config.get(policyConfig.trusted_dir);
        File revokedDirFromConfig = (File)config.get(policyConfig.revoked_dir);
        String privateKeyPassword = (String)config.get(policyConfig.private_key_password);
        boolean allowKeyGeneration = (Boolean)config.get(policyConfig.allow_key_generation);
        boolean trustAll = (Boolean)config.get(policyConfig.trust_all);
        List tlsVersions = (List)config.get(policyConfig.tls_versions);
        List ciphers = (List)config.get(policyConfig.ciphers);
        ClientAuth clientAuth = (ClientAuth)config.get(policyConfig.client_auth);
        Assert.assertEquals((Object)privateKey, (Object)privateKeyFromConfig);
        Assert.assertEquals((Object)publicCertificate, (Object)publicCertificateFromConfig);
        Assert.assertEquals((Object)trustedDir, (Object)trustedDirFromConfig);
        Assert.assertEquals((Object)revokedDir, (Object)revokedDirFromConfig);
        Assert.assertTrue((boolean)allowKeyGeneration);
        Assert.assertTrue((boolean)trustAll);
        Assert.assertEquals((Object)"setecastronomy", (Object)privateKeyPassword);
        Assert.assertEquals(Arrays.asList("TLSv1.1", "TLSv1.2"), (Object)tlsVersions);
        Assert.assertEquals(Arrays.asList("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384"), (Object)ciphers);
        Assert.assertEquals((Object)ClientAuth.OPTIONAL, (Object)clientAuth);
    }

    @Test
    public void shouldFailWithIncompletePathOverrides() {
        Map params = MapUtil.stringMap((String[])new String[0]);
        String policyName = "XYZ";
        SslPolicyConfig policyConfig = new SslPolicyConfig(policyName);
        File homeDir = this.testDirectory.directory("home");
        params.put(GraphDatabaseSettings.neo4j_home.name(), homeDir.getAbsolutePath());
        params.put(policyConfig.base_directory.name(), "certificates");
        params.put(policyConfig.private_key.name(), "my.key");
        params.put(policyConfig.public_certificate.name(), "path/to/my.crt");
        Config config = Config.defaults((Map)params);
        try {
            config.get(policyConfig.private_key);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            config.get(policyConfig.public_certificate);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

