/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.time.Clock;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.junit.Before;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.collection.pool.Pool;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.api.explicitindex.AutoIndexing;
import org.neo4j.kernel.api.txstate.ExplicitIndexTransactionState;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.SchemaState;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionHeaderInformation;
import org.neo4j.kernel.impl.api.TransactionHooks;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.constraints.StandardConstraintSemantics;
import org.neo4j.kernel.impl.factory.AccessCapability;
import org.neo4j.kernel.impl.factory.CanWrite;
import org.neo4j.kernel.impl.index.ExplicitIndexStore;
import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.NoOpClient;
import org.neo4j.kernel.impl.locking.SimpleStatementLocks;
import org.neo4j.kernel.impl.locking.StatementLocks;
import org.neo4j.kernel.impl.newapi.DefaultCursors;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.StoreStatement;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionTracer;
import org.neo4j.kernel.impl.util.collection.CollectionsFactory;
import org.neo4j.kernel.impl.util.collection.OnHeapCollectionsFactory;
import org.neo4j.kernel.impl.util.diffsets.PrimitiveLongDiffSets;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.resources.CpuClock;
import org.neo4j.resources.HeapAllocation;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.lock.ResourceLocker;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;

public class KernelTransactionTestBase {
    protected final StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
    protected final NeoStores neoStores = (NeoStores)Mockito.mock(NeoStores.class);
    protected final MetaDataStore metaDataStore = (MetaDataStore)Mockito.mock(MetaDataStore.class);
    protected final StoreReadLayer readLayer = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
    protected final TransactionHooks hooks = new TransactionHooks();
    protected final ExplicitIndexTransactionState explicitIndexState = (ExplicitIndexTransactionState)Mockito.mock(ExplicitIndexTransactionState.class);
    protected final Supplier<ExplicitIndexTransactionState> explicitIndexStateSupplier = () -> this.explicitIndexState;
    protected final TransactionMonitor transactionMonitor = (TransactionMonitor)Mockito.mock(TransactionMonitor.class);
    protected final CapturingCommitProcess commitProcess = new CapturingCommitProcess();
    protected final TransactionHeaderInformation headerInformation = (TransactionHeaderInformation)Mockito.mock(TransactionHeaderInformation.class);
    protected final TransactionHeaderInformationFactory headerInformationFactory = (TransactionHeaderInformationFactory)Mockito.mock(TransactionHeaderInformationFactory.class);
    protected final SchemaWriteGuard schemaWriteGuard = (SchemaWriteGuard)Mockito.mock(SchemaWriteGuard.class);
    protected final FakeClock clock = Clocks.fakeClock();
    protected final Pool<KernelTransactionImplementation> txPool = (Pool)Mockito.mock(Pool.class);
    protected final StatementOperationParts statementOperations = (StatementOperationParts)Mockito.mock(StatementOperationParts.class);
    protected CollectionsFactory collectionsFactory;
    private final long defaultTransactionTimeoutMillis = ((Duration)Config.defaults().get(GraphDatabaseSettings.transaction_timeout)).toMillis();

    @Before
    public void before() throws Exception {
        this.collectionsFactory = (CollectionsFactory)Mockito.spy((Object)new TestCollectionsFactory());
        Mockito.when((Object)this.headerInformation.getAdditionalHeader()).thenReturn((Object)new byte[0]);
        Mockito.when((Object)this.headerInformationFactory.create()).thenReturn((Object)this.headerInformation);
        StoreStatement statement = (StoreStatement)Mockito.mock(StoreStatement.class);
        Mockito.when((Object)this.readLayer.newStatement()).thenReturn((Object)statement);
        Mockito.when((Object)this.neoStores.getMetaDataStore()).thenReturn((Object)this.metaDataStore);
        Mockito.when((Object)this.storageEngine.storeReadLayer()).thenReturn((Object)this.readLayer);
        ((StorageEngine)Mockito.doAnswer(invocation -> ((Collection)invocation.getArgument(0)).add(new Command.RelationshipCountsCommand(1, 2, 3, 4L))).when((Object)this.storageEngine)).createCommands(ArgumentMatchers.anyCollection(), (ReadableTransactionState)ArgumentMatchers.any(ReadableTransactionState.class), (StorageStatement)ArgumentMatchers.any(StorageStatement.class), (ResourceLocker)ArgumentMatchers.any(ResourceLocker.class), ArgumentMatchers.anyLong());
    }

    public KernelTransactionImplementation newTransaction(long transactionTimeoutMillis) {
        return this.newTransaction(0L, LoginContext.AUTH_DISABLED, transactionTimeoutMillis);
    }

    public KernelTransactionImplementation newTransaction(LoginContext loginContext) {
        return this.newTransaction(0L, loginContext);
    }

    public KernelTransactionImplementation newTransaction(LoginContext loginContext, Locks.Client locks) {
        return this.newTransaction(0L, loginContext, locks, this.defaultTransactionTimeoutMillis);
    }

    public KernelTransactionImplementation newTransaction(long lastTransactionIdWhenStarted, LoginContext loginContext) {
        return this.newTransaction(lastTransactionIdWhenStarted, loginContext, this.defaultTransactionTimeoutMillis);
    }

    public KernelTransactionImplementation newTransaction(long lastTransactionIdWhenStarted, LoginContext loginContext, long transactionTimeoutMillis) {
        return this.newTransaction(lastTransactionIdWhenStarted, loginContext, (Locks.Client)new NoOpClient(), transactionTimeoutMillis);
    }

    public KernelTransactionImplementation newTransaction(long lastTransactionIdWhenStarted, LoginContext loginContext, Locks.Client locks, long transactionTimeout) {
        KernelTransactionImplementation tx = this.newNotInitializedTransaction();
        SimpleStatementLocks statementLocks = new SimpleStatementLocks(locks);
        SecurityContext securityContext = loginContext.authorize(s -> -1);
        tx.initialize(lastTransactionIdWhenStarted, 0L, (StatementLocks)statementLocks, Transaction.Type.implicit, securityContext, transactionTimeout, 1L);
        return tx;
    }

    public KernelTransactionImplementation newNotInitializedTransaction() {
        return new KernelTransactionImplementation(this.statementOperations, this.schemaWriteGuard, this.hooks, null, null, this.headerInformationFactory, (TransactionCommitProcess)this.commitProcess, this.transactionMonitor, this.explicitIndexStateSupplier, this.txPool, (Clock)this.clock, new AtomicReference<CpuClock>(CpuClock.NOT_AVAILABLE), new AtomicReference<HeapAllocation>(HeapAllocation.NOT_AVAILABLE), TransactionTracer.NULL, LockTracer.NONE, PageCursorTracerSupplier.NULL, this.storageEngine, (AccessCapability)new CanWrite(), new DefaultCursors(), AutoIndexing.UNSUPPORTED, (ExplicitIndexStore)Mockito.mock(ExplicitIndexStore.class), EmptyVersionContextSupplier.EMPTY, () -> this.collectionsFactory, (ConstraintSemantics)new StandardConstraintSemantics(), (SchemaState)Mockito.mock(SchemaState.class), (IndexingService)Mockito.mock(IndexingService.class), (IndexProviderMap)Mockito.mock(IndexProviderMap.class));
    }

    private class TestCollectionsFactory
    implements CollectionsFactory {
        private TestCollectionsFactory() {
        }

        public PrimitiveLongSet newLongSet() {
            return OnHeapCollectionsFactory.INSTANCE.newLongSet();
        }

        public <V> PrimitiveLongObjectMap<V> newLongObjectMap() {
            return OnHeapCollectionsFactory.INSTANCE.newLongObjectMap();
        }

        public <V> PrimitiveIntObjectMap<V> newIntObjectMap() {
            return OnHeapCollectionsFactory.INSTANCE.newIntObjectMap();
        }

        public PrimitiveLongDiffSets newLongDiffSets() {
            return OnHeapCollectionsFactory.INSTANCE.newLongDiffSets();
        }

        public MemoryTracker getMemoryTracker() {
            return OnHeapCollectionsFactory.INSTANCE.getMemoryTracker();
        }

        public boolean collectionsMustBeReleased() {
            return false;
        }
    }

    public class CapturingCommitProcess
    implements TransactionCommitProcess {
        private long txId = 1L;
        public TransactionRepresentation transaction;

        public long commit(TransactionToApply batch, CommitEvent commitEvent, TransactionApplicationMode mode) {
            assert (this.transaction == null) : "Designed to only allow one transaction";
            assert (batch.next() == null) : "Designed to only allow one transaction";
            this.transaction = batch.transactionRepresentation();
            return ++this.txId;
        }
    }
}

