/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.graphdb.mockfs.UncloseableDelegatingFileSystemAbstraction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptorFactory;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexProvider;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexProviderFactory;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingController;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class IndexStatisticsIT {
    private static final Label ALIEN = Label.label((String)"Alien");
    private static final String SPECIMEN = "specimen";
    @Rule
    public final EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    private final InMemoryIndexProvider indexProvider = new InMemoryIndexProvider(100);
    private final AssertableLogProvider logProvider = new AssertableLogProvider();
    private GraphDatabaseService db;

    @Before
    public void before() {
        this.setupDb((EphemeralFileSystemAbstraction)this.fsRule.get());
    }

    @After
    public void after() {
        try {
            this.db.shutdown();
        }
        finally {
            this.db = null;
        }
    }

    @Test
    public void shouldRecoverIndexCountsBySamplingThemOnStartup() {
        this.createAliens();
        this.awaitIndexOnline(this.indexAliensBySpecimen());
        SchemaIndexDescriptor index = SchemaIndexDescriptorFactory.forLabel((int)this.labelId(ALIEN), (int[])new int[]{this.pkId(SPECIMEN)});
        SchemaStorage storage = new SchemaStorage((RecordStore)this.neoStores().getSchemaStore());
        long indexId = storage.indexGetForSchema(index).getId();
        this.resetIndexCounts(indexId);
        this.restart();
        CountsTracker tracker = this.neoStores().getCounts();
        this.assertEqualRegisters("Unexpected updates and size for the index", Registers.newDoubleLongRegister((long)0L, (long)32L), tracker.indexUpdatesAndSize(indexId, Registers.newDoubleLongRegister()));
        this.assertEqualRegisters("Unexpected sampling result", Registers.newDoubleLongRegister((long)16L, (long)32L), tracker.indexSample(indexId, Registers.newDoubleLongRegister()));
        this.assertLogExistsForRecoveryOn(":Alien(specimen)");
    }

    private void assertEqualRegisters(String message, Register.DoubleLongRegister expected, Register.DoubleLongRegister actual) {
        Assert.assertEquals((String)(message + " (first part of register)"), (long)expected.readFirst(), (long)actual.readFirst());
        Assert.assertEquals((String)(message + " (second part of register)"), (long)expected.readSecond(), (long)actual.readSecond());
    }

    private void assertLogExistsForRecoveryOn(String labelAndProperty) {
        this.logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(IndexSamplingController.class).debug("Recovering index sampling for index %s", new Object[]{labelAndProperty})});
    }

    private int labelId(Label alien) {
        try (Transaction ignore = this.db.beginTx();){
            int n = this.ktx().tokenRead().nodeLabel(alien.name());
            return n;
        }
    }

    private int pkId(String propertyName) {
        try (Transaction ignore = this.db.beginTx();){
            int n = this.ktx().tokenRead().propertyKey(propertyName);
            return n;
        }
    }

    private KernelTransaction ktx() {
        return ((ThreadToStatementContextBridge)((GraphDatabaseAPI)this.db).getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class)).getKernelTransactionBoundToThisThread(true);
    }

    private void createAliens() {
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < 32; ++i) {
                Node alien = this.db.createNode(new Label[]{ALIEN});
                alien.setProperty(SPECIMEN, (Object)(i / 2));
            }
            tx.success();
        }
    }

    private void awaitIndexOnline(IndexDefinition definition) {
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().awaitIndexOnline(definition, 10L, TimeUnit.SECONDS);
            tx.success();
        }
    }

    private IndexDefinition indexAliensBySpecimen() {
        try (Transaction tx = this.db.beginTx();){
            IndexDefinition definition = this.db.schema().indexFor(ALIEN).on(SPECIMEN).create();
            tx.success();
            IndexDefinition indexDefinition = definition;
            return indexDefinition;
        }
    }

    private void resetIndexCounts(long indexId) {
        try (CountsAccessor.IndexStatsUpdater updater = this.neoStores().getCounts().updateIndexCounts();){
            updater.replaceIndexSample(indexId, 0L, 0L);
            updater.replaceIndexUpdateAndSize(indexId, 0L, 0L);
        }
    }

    private NeoStores neoStores() {
        return ((RecordStorageEngine)((GraphDatabaseAPI)this.db).getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
    }

    private void setupDb(EphemeralFileSystemAbstraction fs) {
        this.db = new TestGraphDatabaseFactory().setInternalLogProvider((LogProvider)this.logProvider).setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction((FileSystemAbstraction)fs)).setKernelExtensions(Arrays.asList(new KernelExtensionFactory[]{new InMemoryIndexProviderFactory(this.indexProvider)})).newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.index_background_sampling_enabled, "false").newGraphDatabase();
    }

    public void restart() {
        this.db.shutdown();
        this.setupDb(((EphemeralFileSystemAbstraction)this.fsRule.get()).snapshot());
    }
}

