/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking.community;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.locking.community.LockManagerImpl;
import org.neo4j.kernel.impl.locking.community.LockNotFoundException;
import org.neo4j.kernel.impl.locking.community.LockResource;
import org.neo4j.kernel.impl.locking.community.LockTransaction;
import org.neo4j.kernel.impl.locking.community.RWLock;
import org.neo4j.kernel.impl.locking.community.RagManager;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.time.Clocks;

public class LockManagerImplTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void shouldAllowGetReadWriteLocks() {
        LockResource node1 = new LockResource((ResourceType)ResourceTypes.NODE, 1L);
        LockResource node2 = new LockResource((ResourceType)ResourceTypes.NODE, 2L);
        LockTransaction lockTransaction = new LockTransaction();
        LockManagerImpl lockManager = this.createLockManager();
        Assert.assertTrue((boolean)lockManager.getReadLock(LockTracer.NONE, node1, (Object)lockTransaction));
        Assert.assertTrue((boolean)lockManager.getReadLock(LockTracer.NONE, node2, (Object)lockTransaction));
        Assert.assertTrue((boolean)lockManager.getWriteLock(LockTracer.NONE, node2, (Object)lockTransaction));
        lockManager.releaseReadLock((Object)node1, (Object)lockTransaction);
        lockManager.releaseReadLock((Object)node2, (Object)lockTransaction);
        lockManager.releaseWriteLock((Object)node2, (Object)lockTransaction);
        int lockCount = this.countLocks(lockManager);
        Assert.assertEquals((long)0L, (long)lockCount);
    }

    @Test
    public void shouldNotBePossibleReleaseNotExistingLock() {
        LockResource node1 = new LockResource((ResourceType)ResourceTypes.NODE, 1L);
        LockTransaction lockTransaction = new LockTransaction();
        LockManagerImpl lockManager = this.createLockManager();
        this.expectedException.expect(LockNotFoundException.class);
        this.expectedException.expectMessage("Lock not found for: ");
        lockManager.releaseReadLock((Object)node1, (Object)lockTransaction);
    }

    @Test
    public void shouldCleanupNotUsedLocks() {
        LockResource node = new LockResource((ResourceType)ResourceTypes.NODE, 1L);
        LockTransaction lockTransaction = new LockTransaction();
        LockManagerImpl lockManager = this.createLockManager();
        lockManager.getWriteLock(LockTracer.NONE, node, (Object)lockTransaction);
        Assert.assertTrue((boolean)lockManager.tryReadLock(node, (Object)lockTransaction));
        Assert.assertEquals((long)1L, (long)this.countLocks(lockManager));
        lockManager.releaseWriteLock((Object)node, (Object)lockTransaction);
        Assert.assertEquals((long)1L, (long)this.countLocks(lockManager));
        lockManager.releaseReadLock((Object)node, (Object)lockTransaction);
        Assert.assertEquals((long)0L, (long)this.countLocks(lockManager));
    }

    @Test
    public void shouldReleaseNotAcquiredLocks() {
        LockResource node = new LockResource((ResourceType)ResourceTypes.NODE, 1L);
        LockTransaction lockTransaction = new LockTransaction();
        RWLock rwLock = (RWLock)Mockito.mock(RWLock.class);
        MockedLockLockManager lockManager = new MockedLockLockManager(new RagManager(), rwLock);
        lockManager.tryReadLock(node, lockTransaction);
        Assert.assertEquals((long)0L, (long)this.countLocks(lockManager));
    }

    private LockManagerImpl createLockManager() {
        return new LockManagerImpl(new RagManager(), Config.defaults(), Clocks.systemClock());
    }

    private int countLocks(LockManagerImpl lockManager) {
        int[] counter = new int[1];
        lockManager.accept(element -> {
            counter[0] = counter[0] + 1;
            return false;
        });
        return counter[0];
    }

    private class MockedLockLockManager
    extends LockManagerImpl {
        private RWLock lock;

        MockedLockLockManager(RagManager ragManager, RWLock lock) {
            super(ragManager, Config.defaults(), Clocks.systemClock());
            this.lock = lock;
        }

        protected RWLock createLock(LockResource resource) {
            return this.lock;
        }
    }
}

