/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.concurrent.ThreadLocalRandom;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.newapi.GroupReferenceEncoding;
import org.neo4j.kernel.impl.newapi.References;
import org.neo4j.kernel.impl.newapi.RelationshipReferenceEncoding;

public class ReferencesTest {
    private static long MAX_ID_LIMIT = 0x4000000000000L;

    @Test
    public void shouldPreserveNoId() {
        MatcherAssert.assertThat((Object)RelationshipReferenceEncoding.encodeForFiltering((long)-1L), (Matcher)CoreMatchers.equalTo((Object)-1L));
        MatcherAssert.assertThat((Object)RelationshipReferenceEncoding.encodeForTxStateFiltering((long)-1L), (Matcher)CoreMatchers.equalTo((Object)-1L));
        MatcherAssert.assertThat((Object)RelationshipReferenceEncoding.encodeGroup((long)-1L), (Matcher)CoreMatchers.equalTo((Object)-1L));
        MatcherAssert.assertThat((Object)RelationshipReferenceEncoding.encodeNoIncomingRels((int)-1), (Matcher)CoreMatchers.equalTo((Object)-1L));
        MatcherAssert.assertThat((Object)RelationshipReferenceEncoding.encodeNoOutgoingRels((int)-1), (Matcher)CoreMatchers.equalTo((Object)-1L));
        MatcherAssert.assertThat((Object)RelationshipReferenceEncoding.encodeNoLoopRels((int)-1), (Matcher)CoreMatchers.equalTo((Object)-1L));
        MatcherAssert.assertThat((Object)GroupReferenceEncoding.encodeRelationship((long)-1L), (Matcher)CoreMatchers.equalTo((Object)-1L));
    }

    @Test
    public void shouldClearFlags() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < 1000; ++i) {
            long reference = random.nextLong(MAX_ID_LIMIT);
            int token = random.nextInt(Integer.MAX_VALUE);
            MatcherAssert.assertThat((Object)References.clearEncoding((long)RelationshipReferenceEncoding.encodeGroup((long)reference)), (Matcher)CoreMatchers.equalTo((Object)reference));
            MatcherAssert.assertThat((Object)References.clearEncoding((long)RelationshipReferenceEncoding.encodeForFiltering((long)reference)), (Matcher)CoreMatchers.equalTo((Object)reference));
            MatcherAssert.assertThat((Object)References.clearEncoding((long)RelationshipReferenceEncoding.encodeForTxStateFiltering((long)reference)), (Matcher)CoreMatchers.equalTo((Object)reference));
            MatcherAssert.assertThat((Object)References.clearEncoding((long)RelationshipReferenceEncoding.encodeNoIncomingRels((int)token)), (Matcher)CoreMatchers.equalTo((Object)token));
            MatcherAssert.assertThat((Object)References.clearEncoding((long)RelationshipReferenceEncoding.encodeNoOutgoingRels((int)token)), (Matcher)CoreMatchers.equalTo((Object)token));
            MatcherAssert.assertThat((Object)References.clearEncoding((long)RelationshipReferenceEncoding.encodeNoLoopRels((int)token)), (Matcher)CoreMatchers.equalTo((Object)token));
            MatcherAssert.assertThat((Object)References.clearEncoding((long)GroupReferenceEncoding.encodeRelationship((long)reference)), (Matcher)CoreMatchers.equalTo((Object)reference));
        }
    }

    @Test
    public void encodeForFiltering() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < 1000; ++i) {
            long reference = random.nextLong(MAX_ID_LIMIT);
            Assert.assertNotEquals((Object)RelationshipReferenceEncoding.FILTER, (Object)RelationshipReferenceEncoding.parseEncoding((long)reference));
            Assert.assertEquals((Object)RelationshipReferenceEncoding.FILTER, (Object)RelationshipReferenceEncoding.parseEncoding((long)RelationshipReferenceEncoding.encodeForFiltering((long)reference)));
            Assert.assertTrue((String)"encoded reference is negative", (RelationshipReferenceEncoding.encodeForFiltering((long)reference) < 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void encodeForTxStateFiltering() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < 1000; ++i) {
            long reference = random.nextLong(MAX_ID_LIMIT);
            Assert.assertNotEquals((Object)RelationshipReferenceEncoding.FILTER_TX_STATE, (Object)RelationshipReferenceEncoding.parseEncoding((long)reference));
            Assert.assertEquals((Object)RelationshipReferenceEncoding.FILTER_TX_STATE, (Object)RelationshipReferenceEncoding.parseEncoding((long)RelationshipReferenceEncoding.encodeForTxStateFiltering((long)reference)));
            Assert.assertTrue((String)"encoded reference is negative", (RelationshipReferenceEncoding.encodeForTxStateFiltering((long)reference) < 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void encodeFromGroup() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < 1000; ++i) {
            long reference = random.nextLong(MAX_ID_LIMIT);
            Assert.assertNotEquals((Object)RelationshipReferenceEncoding.GROUP, (Object)RelationshipReferenceEncoding.parseEncoding((long)reference));
            Assert.assertEquals((Object)RelationshipReferenceEncoding.GROUP, (Object)RelationshipReferenceEncoding.parseEncoding((long)RelationshipReferenceEncoding.encodeGroup((long)reference)));
            Assert.assertTrue((String)"encoded reference is negative", (RelationshipReferenceEncoding.encodeGroup((long)reference) < 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void encodeNoIncomingRels() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < 1000; ++i) {
            int token = random.nextInt(Integer.MAX_VALUE);
            Assert.assertNotEquals((Object)RelationshipReferenceEncoding.NO_INCOMING_OF_TYPE, (Object)RelationshipReferenceEncoding.parseEncoding((long)token));
            Assert.assertEquals((Object)RelationshipReferenceEncoding.NO_INCOMING_OF_TYPE, (Object)RelationshipReferenceEncoding.parseEncoding((long)RelationshipReferenceEncoding.encodeNoIncomingRels((int)token)));
            Assert.assertTrue((String)"encoded reference is negative", (RelationshipReferenceEncoding.encodeNoIncomingRels((int)token) < 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void encodeNoOutgoingRels() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < 1000; ++i) {
            int token = random.nextInt(Integer.MAX_VALUE);
            Assert.assertNotEquals((Object)RelationshipReferenceEncoding.NO_OUTGOING_OF_TYPE, (Object)RelationshipReferenceEncoding.parseEncoding((long)token));
            Assert.assertEquals((Object)RelationshipReferenceEncoding.NO_OUTGOING_OF_TYPE, (Object)RelationshipReferenceEncoding.parseEncoding((long)RelationshipReferenceEncoding.encodeNoOutgoingRels((int)token)));
            Assert.assertTrue((String)"encoded reference is negative", (RelationshipReferenceEncoding.encodeNoOutgoingRels((int)token) < 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void encodeNoLoopRels() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < 1000; ++i) {
            int token = random.nextInt(Integer.MAX_VALUE);
            Assert.assertNotEquals((Object)RelationshipReferenceEncoding.NO_LOOP_OF_TYPE, (Object)RelationshipReferenceEncoding.parseEncoding((long)token));
            Assert.assertEquals((Object)RelationshipReferenceEncoding.NO_LOOP_OF_TYPE, (Object)RelationshipReferenceEncoding.parseEncoding((long)RelationshipReferenceEncoding.encodeNoLoopRels((int)token)));
            Assert.assertTrue((String)"encoded reference is negative", (RelationshipReferenceEncoding.encodeNoLoopRels((int)token) < 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void encodeRelationship() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < 1000; ++i) {
            long reference = random.nextLong(MAX_ID_LIMIT);
            Assert.assertFalse((boolean)GroupReferenceEncoding.isRelationship((long)reference));
            Assert.assertTrue((boolean)GroupReferenceEncoding.isRelationship((long)GroupReferenceEncoding.encodeRelationship((long)reference)));
            Assert.assertTrue((String)"encoded reference is negative", (GroupReferenceEncoding.encodeRelationship((long)reference) < 0L ? 1 : 0) != 0);
        }
    }
}

