/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import org.apache.commons.lang3.SystemUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.ConfigurablePageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class TestGrowingFileMemoryMapping {
    private final ConfigurablePageCacheRule pageCacheRule = new ConfigurablePageCacheRule();
    private final TestDirectory testDirectory = TestDirectory.testDirectory();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.testDirectory).around((TestRule)this.fileSystemRule).around((TestRule)this.pageCacheRule);

    @Test
    public void shouldGrowAFileWhileContinuingToMemoryMapNewRegions() {
        long startingId;
        Assume.assumeTrue((!SystemUtils.IS_OS_WINDOWS ? 1 : 0) != 0);
        int NUMBER_OF_RECORDS = 1000000;
        File storeDir = this.testDirectory.graphDbDir();
        Config config = Config.defaults((Setting)GraphDatabaseSettings.pagecache_memory, (String)this.mmapSize(1000000, 15));
        FileSystemAbstraction fileSystemAbstraction = this.fileSystemRule.get();
        DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory(fileSystemAbstraction);
        PageCache pageCache = this.pageCacheRule.getPageCache(fileSystemAbstraction, config);
        StoreFactory storeFactory = new StoreFactory(storeDir, config, (IdGeneratorFactory)idGeneratorFactory, pageCache, fileSystemAbstraction, (LogProvider)NullLogProvider.getInstance(), EmptyVersionContextSupplier.EMPTY);
        NeoStores neoStores = storeFactory.openAllNeoStores(true);
        NodeStore nodeStore = neoStores.getNodeStore();
        int iterations = 2000000;
        long nodeId = startingId = nodeStore.nextId();
        for (int i = 0; i < iterations; ++i) {
            NodeRecord record = new NodeRecord(nodeId, false, (long)i, 0L);
            record.setInUse(true);
            nodeStore.updateRecord(record);
            nodeId = nodeStore.nextId();
        }
        NodeRecord record = new NodeRecord(0L, false, 0L, 0L);
        for (int i = 0; i < iterations; ++i) {
            record.setId(startingId + (long)i);
            nodeStore.getRecord((long)i, (AbstractBaseRecord)record, RecordLoad.NORMAL);
            Assert.assertTrue((String)("record[" + i + "] should be in use"), (boolean)record.inUse());
            Assert.assertThat((String)("record[" + i + "] should have nextRelId of " + i), (Object)record.getNextRel(), (Matcher)Matchers.is((Object)i));
        }
        neoStores.close();
    }

    private String mmapSize(int numberOfRecords, int recordSize) {
        int bytes = numberOfRecords * recordSize;
        long mebiByte = ByteUnit.mebiBytes((long)1L);
        if ((long)bytes < mebiByte) {
            throw new IllegalArgumentException("too few records: " + numberOfRecords);
        }
        return (long)bytes / mebiByte + "M";
    }
}

