/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format;

import java.io.IOException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.StoreHeader;
import org.neo4j.kernel.impl.store.format.RecordFormat;
import org.neo4j.kernel.impl.store.id.IdSequence;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;

public class ForcedSecondaryUnitRecordFormat<RECORD extends AbstractBaseRecord>
implements RecordFormat<RECORD> {
    private final RecordFormat<RECORD> actual;

    public ForcedSecondaryUnitRecordFormat(RecordFormat<RECORD> actual) {
        this.actual = actual;
    }

    public RECORD newRecord() {
        return (RECORD)this.actual.newRecord();
    }

    public int getRecordSize(StoreHeader storeHeader) {
        return this.actual.getRecordSize(storeHeader);
    }

    public int getRecordHeaderSize() {
        return this.actual.getRecordHeaderSize();
    }

    public boolean isInUse(PageCursor cursor) {
        return this.actual.isInUse(cursor);
    }

    public void read(RECORD record, PageCursor cursor, RecordLoad mode, int recordSize) throws IOException {
        this.actual.read(record, cursor, mode, recordSize);
    }

    public void prepare(RECORD record, int recordSize, IdSequence idSequence) {
        this.actual.prepare(record, recordSize, idSequence);
        if (!record.hasSecondaryUnitId()) {
            record.setSecondaryUnitId(idSequence.nextId());
        }
    }

    public void write(RECORD record, PageCursor cursor, int recordSize) throws IOException {
        this.actual.write(record, cursor, recordSize);
    }

    public long getNextRecordReference(RECORD record) {
        return this.actual.getNextRecordReference(record);
    }

    public boolean equals(Object otherFormat) {
        return this.actual.equals(otherFormat);
    }

    public int hashCode() {
        return this.actual.hashCode();
    }

    public long getMaxId() {
        return this.actual.getMaxId();
    }
}

