/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.SystemUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.test.rule.TestDirectory;

public class FileUtilsTest {
    public TestDirectory testDirectory = TestDirectory.testDirectory();
    public ExpectedException expected = ExpectedException.none();
    public FileSystemAbstraction fs = new DefaultFileSystemAbstraction();
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.testDirectory).around((TestRule)this.expected);
    private File path;

    @Before
    public void doBefore() {
        this.path = this.testDirectory.directory("path");
    }

    @Test
    public void moveFileToDirectory() throws Exception {
        File file = this.touchFile("source");
        File targetDir = this.directory("dir");
        File newLocationOfFile = FileUtils.moveFileToDirectory((File)file, (File)targetDir);
        Assert.assertTrue((boolean)newLocationOfFile.exists());
        Assert.assertFalse((boolean)file.exists());
        Assert.assertEquals((Object)newLocationOfFile, (Object)targetDir.listFiles()[0]);
    }

    @Test
    public void moveFile() throws Exception {
        File file = this.touchFile("source");
        File targetDir = this.directory("dir");
        File newLocationOfFile = new File(targetDir, "new-name");
        FileUtils.moveFile((File)file, (File)newLocationOfFile);
        Assert.assertTrue((boolean)newLocationOfFile.exists());
        Assert.assertFalse((boolean)file.exists());
        Assert.assertEquals((Object)newLocationOfFile, (Object)targetDir.listFiles()[0]);
    }

    @Test
    public void testEmptyDirectory() throws IOException {
        File emptyDir = this.directory("emptyDir");
        File nonEmptyDir = this.directory("nonEmptyDir");
        File directoryContent = new File(nonEmptyDir, "somefile");
        assert (directoryContent.createNewFile());
        Assert.assertTrue((boolean)FileUtils.isEmptyDirectory((File)emptyDir));
        Assert.assertFalse((boolean)FileUtils.isEmptyDirectory((File)nonEmptyDir));
    }

    @Test
    public void pathToFileAfterMoveMustThrowIfFileNotSubPathToFromShorter() {
        File file = new File("/a");
        File from = new File("/a/b");
        File to = new File("/a/c");
        this.expected.expect(IllegalArgumentException.class);
        FileUtils.pathToFileAfterMove((File)from, (File)to, (File)file);
    }

    @Test
    public void pathToFileAfterMoveMustThrowIfFileNotSubPathToFromSameLength() {
        File file = new File("/a/f");
        File from = new File("/a/b");
        File to = new File("/a/c");
        this.expected.expect(IllegalArgumentException.class);
        FileUtils.pathToFileAfterMove((File)from, (File)to, (File)file);
    }

    @Test
    public void pathToFileAfterMoveMustThrowIfFileNotSubPathToFromLonger() {
        File file = new File("/a/c/f");
        File from = new File("/a/b");
        File to = new File("/a/c");
        this.expected.expect(IllegalArgumentException.class);
        FileUtils.pathToFileAfterMove((File)from, (File)to, (File)file);
    }

    @Test
    public void pathToFileAfterMoveMustThrowIfFromDirIsCompletePathToFile() {
        File file = new File("/a/b/f");
        File from = new File("/a/b/f");
        File to = new File("/a/c");
        this.expected.expect(IllegalArgumentException.class);
        FileUtils.pathToFileAfterMove((File)from, (File)to, (File)file);
    }

    @Test
    public void pathToFileAfterMoveMustWorkIfMovingToSibling() {
        File file = new File("/a/b/f");
        File from = new File("/a/b");
        File to = new File("/a/c");
        Assert.assertThat((Object)FileUtils.pathToFileAfterMove((File)from, (File)to, (File)file).getPath(), (Matcher)Matchers.is((Object)this.path("/a/c/f")));
    }

    @Test
    public void pathToFileAfterMoveMustWorkIfMovingToSiblingAndFileHasSubDir() {
        File file = new File("/a/b/d/f");
        File from = new File("/a/b");
        File to = new File("/a/c");
        Assert.assertThat((Object)FileUtils.pathToFileAfterMove((File)from, (File)to, (File)file).getPath(), (Matcher)Matchers.is((Object)this.path("/a/c/d/f")));
    }

    @Test
    public void pathToFileAfterMoveMustWorkIfMovingToSubDir() {
        File file = new File("/a/b/f");
        File from = new File("/a/b");
        File to = new File("/a/b/c");
        Assert.assertThat((Object)FileUtils.pathToFileAfterMove((File)from, (File)to, (File)file).getPath(), (Matcher)Matchers.is((Object)this.path("/a/b/c/f")));
    }

    @Test
    public void pathToFileAfterMoveMustWorkIfMovingToSubDirAndFileHasSubDir() {
        File file = new File("/a/b/d/f");
        File from = new File("/a/b");
        File to = new File("/a/b/c");
        Assert.assertThat((Object)FileUtils.pathToFileAfterMove((File)from, (File)to, (File)file).getPath(), (Matcher)Matchers.is((Object)this.path("/a/b/c/d/f")));
    }

    @Test
    public void pathToFileAfterMoveMustWorkIfMovingOutOfDir() {
        File file = new File("/a/b/f");
        File from = new File("/a/b");
        File to = new File("/c");
        Assert.assertThat((Object)FileUtils.pathToFileAfterMove((File)from, (File)to, (File)file).getPath(), (Matcher)Matchers.is((Object)this.path("/c/f")));
    }

    @Test
    public void pathToFileAfterMoveMustWorkIfMovingOutOfDirAndFileHasSubDir() {
        File file = new File("/a/b/d/f");
        File from = new File("/a/b");
        File to = new File("/c");
        Assert.assertThat((Object)FileUtils.pathToFileAfterMove((File)from, (File)to, (File)file).getPath(), (Matcher)Matchers.is((Object)this.path("/c/d/f")));
    }

    @Test
    public void pathToFileAfterMoveMustWorkIfNotMovingAtAll() {
        File file = new File("/a/b/f");
        File from = new File("/a/b");
        File to = new File("/a/b");
        Assert.assertThat((Object)FileUtils.pathToFileAfterMove((File)from, (File)to, (File)file).getPath(), (Matcher)Matchers.is((Object)this.path("/a/b/f")));
    }

    @Test
    public void pathToFileAfterMoveMustWorkIfNotMovingAtAllAndFileHasSubDir() {
        File file = new File("/a/b/d/f");
        File from = new File("/a/b");
        File to = new File("/a/b");
        Assert.assertThat((Object)FileUtils.pathToFileAfterMove((File)from, (File)to, (File)file).getPath(), (Matcher)Matchers.is((Object)this.path("/a/b/d/f")));
    }

    @Test
    public void allMacsHaveHighIO() {
        Assume.assumeTrue((boolean)SystemUtils.IS_OS_MAC);
        Assert.assertTrue((boolean)FileUtils.highIODevice((Path)Paths.get(".", new String[0]), (boolean)false));
    }

    @Test
    public void windowsNeverHaveHighIO() {
        Assume.assumeTrue((boolean)SystemUtils.IS_OS_WINDOWS);
        Assert.assertFalse((boolean)FileUtils.highIODevice((Path)Paths.get(".", new String[0]), (boolean)false));
    }

    @Test
    public void onLinuxDevShmHasHighIO() {
        Assume.assumeTrue((boolean)SystemUtils.IS_OS_LINUX);
        Assert.assertTrue((boolean)FileUtils.highIODevice((Path)Paths.get("/dev/shm", new String[0]), (boolean)false));
    }

    @Test
    public void sizeOfFile() throws Exception {
        File file = this.touchFile("a");
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.append('a');
        }
        Assert.assertThat((Object)FileUtils.size((FileSystemAbstraction)this.fs, (File)file), (Matcher)Matchers.is((Object)1L));
    }

    @Test
    public void sizeOfDirector() throws Exception {
        File dir = this.directory("dir");
        File file1 = new File(dir, "file1");
        File file2 = new File(dir, "file2");
        try (FileWriter fileWriter = new FileWriter(file1);){
            fileWriter.append('a').append('b');
        }
        fileWriter = new FileWriter(file2);
        var5_5 = null;
        try {
            fileWriter.append('a');
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (fileWriter != null) {
                if (var5_5 != null) {
                    try {
                        fileWriter.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    fileWriter.close();
                }
            }
        }
        Assert.assertThat((Object)FileUtils.size((FileSystemAbstraction)this.fs, (File)dir), (Matcher)Matchers.is((Object)3L));
    }

    @Test
    public void mustCountDirectoryContents() throws Exception {
        File dir = this.directory("dir");
        File file = new File(dir, "file");
        File subdir = new File(dir, "subdir");
        file.createNewFile();
        subdir.mkdirs();
        Assert.assertThat((Object)FileUtils.countFilesInDirectoryPath((Path)dir.toPath()), (Matcher)Matchers.is((Object)2L));
    }

    private File directory(String name) {
        File dir = new File(this.path, name);
        dir.mkdirs();
        return dir;
    }

    private File touchFile(String name) throws IOException {
        File file = new File(this.path, name);
        file.createNewFile();
        return file;
    }

    private String path(String path) {
        return new File(path).getPath();
    }
}

