/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.CheckPoint;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.kernel.recovery.LogTailScanner;
import org.neo4j.kernel.recovery.RecoveryStartInformation;
import org.neo4j.kernel.recovery.RecoveryStartInformationProvider;

public class RecoveryStartInformationProviderTest {
    private final long currentLogVersion = 2L;
    private final long logVersion = 2L;
    private final LogTailScanner tailScanner = (LogTailScanner)Mockito.mock(LogTailScanner.class);
    private final RecoveryStartInformationProvider.Monitor monitor = (RecoveryStartInformationProvider.Monitor)Mockito.mock(RecoveryStartInformationProvider.Monitor.class);

    @Test
    public void shouldReturnUnspecifiedIfThereIsNoNeedForRecovery() {
        Mockito.when((Object)this.tailScanner.getTailInformation()).thenReturn((Object)new LogTailScanner.LogTailInformation(false, LogTailScanner.NO_TRANSACTION_ID, 2L, 2L, LogEntryVersion.CURRENT));
        RecoveryStartInformation recoveryStartInformation = new RecoveryStartInformationProvider(this.tailScanner, this.monitor).get();
        ((RecoveryStartInformationProvider.Monitor)Mockito.verify((Object)this.monitor)).noCommitsAfterLastCheckPoint(null);
        Assert.assertEquals((Object)LogPosition.UNSPECIFIED, (Object)recoveryStartInformation.getRecoveryPosition());
        Assert.assertEquals((long)LogTailScanner.NO_TRANSACTION_ID, (long)recoveryStartInformation.getFirstTxIdAfterLastCheckPoint());
        Assert.assertFalse((boolean)recoveryStartInformation.isRecoveryRequired());
    }

    @Test
    public void shouldReturnLogPositionToRecoverFromIfNeeded() {
        LogPosition checkPointLogPosition = new LogPosition(1L, 4242L);
        Mockito.when((Object)this.tailScanner.getTailInformation()).thenReturn((Object)new LogTailScanner.LogTailInformation(new CheckPoint(checkPointLogPosition), true, 10L, 2L, 2L, LogEntryVersion.CURRENT));
        RecoveryStartInformation recoveryStartInformation = new RecoveryStartInformationProvider(this.tailScanner, this.monitor).get();
        ((RecoveryStartInformationProvider.Monitor)Mockito.verify((Object)this.monitor)).commitsAfterLastCheckPoint(checkPointLogPosition, 10L);
        Assert.assertEquals((Object)checkPointLogPosition, (Object)recoveryStartInformation.getRecoveryPosition());
        Assert.assertEquals((long)10L, (long)recoveryStartInformation.getFirstTxIdAfterLastCheckPoint());
        Assert.assertTrue((boolean)recoveryStartInformation.isRecoveryRequired());
    }

    @Test
    public void shouldRecoverFromStartOfLogZeroIfThereAreNoCheckPointAndOldestLogIsVersionZero() {
        Mockito.when((Object)this.tailScanner.getTailInformation()).thenReturn((Object)new LogTailScanner.LogTailInformation(true, 10L, 0L, 2L, LogEntryVersion.CURRENT));
        RecoveryStartInformation recoveryStartInformation = new RecoveryStartInformationProvider(this.tailScanner, this.monitor).get();
        ((RecoveryStartInformationProvider.Monitor)Mockito.verify((Object)this.monitor)).noCheckPointFound();
        Assert.assertEquals((Object)LogPosition.start((long)0L), (Object)recoveryStartInformation.getRecoveryPosition());
        Assert.assertEquals((long)10L, (long)recoveryStartInformation.getFirstTxIdAfterLastCheckPoint());
        Assert.assertTrue((boolean)recoveryStartInformation.isRecoveryRequired());
    }

    @Test
    public void shouldFailIfThereAreNoCheckPointsAndOldestLogVersionInNotZero() {
        long oldestLogVersionFound = 1L;
        Mockito.when((Object)this.tailScanner.getTailInformation()).thenReturn((Object)new LogTailScanner.LogTailInformation(true, 10L, oldestLogVersionFound, 2L, LogEntryVersion.CURRENT));
        try {
            new RecoveryStartInformationProvider(this.tailScanner, this.monitor).get();
        }
        catch (UnderlyingStorageException ex) {
            String expectedMessage = "No check point found in any log file from version " + oldestLogVersionFound + " to " + 2L;
            Assert.assertEquals((Object)expectedMessage, (Object)ex.getMessage());
        }
    }
}

