/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.internal.kernel.api.RelationshipGroupCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.newapi.DefaultCursors;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.newapi.RelationshipDirection;
import org.neo4j.kernel.impl.newapi.RelationshipReferenceEncoding;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.storageengine.api.txstate.NodeState;
import org.neo4j.storageengine.api.txstate.RelationshipState;

class DefaultRelationshipGroupCursor
extends RelationshipGroupRecord
implements RelationshipGroupCursor {
    private Read read;
    private final RelationshipRecord edge = new RelationshipRecord(-1L);
    private final DefaultCursors pool;
    private BufferedGroup bufferedGroup;
    private PageCursor page;
    private PageCursor edgePage;
    private boolean hasCheckedTxState;
    private final PrimitiveIntSet txTypes = Primitive.intSet();
    private PrimitiveIntIterator txTypeIterator;

    DefaultRelationshipGroupCursor(DefaultCursors pool) {
        super(-1L);
        this.pool = pool;
    }

    void buffer(long nodeReference, long relationshipReference, Read read) {
        this.setOwningNode(nodeReference);
        this.setId(-1L);
        this.setNext(-1L);
        try (PrimitiveIntObjectMap buffer = Primitive.intObjectMap();
             PageCursor edgePage = read.relationshipPage(relationshipReference);){
            BufferedGroup current = null;
            while (relationshipReference != -1L) {
                read.relationshipFull(this.edge, relationshipReference, edgePage);
                BufferedGroup group = (BufferedGroup)buffer.get(this.edge.getType());
                if (group == null) {
                    current = group = new BufferedGroup(this.edge, current);
                    buffer.put(this.edge.getType(), (Object)group);
                }
                if (this.edge.getFirstNode() == nodeReference) {
                    if (this.edge.getSecondNode() == nodeReference) {
                        group.loop(this.edge);
                    } else {
                        group.outgoing(this.edge);
                    }
                    relationshipReference = this.edge.getFirstNextRel();
                    continue;
                }
                if (this.edge.getSecondNode() == nodeReference) {
                    group.incoming(this.edge);
                    relationshipReference = this.edge.getSecondNextRel();
                    continue;
                }
                throw new IllegalStateException("not a part of the chain! TODO: better exception");
            }
            this.txTypes.clear();
            this.txTypeIterator = null;
            this.hasCheckedTxState = false;
            this.bufferedGroup = new BufferedGroup(this.edge, current);
            this.read = read;
        }
    }

    void direct(long nodeReference, long reference, Read read) {
        this.bufferedGroup = null;
        this.clear();
        this.txTypes.clear();
        this.txTypeIterator = null;
        this.hasCheckedTxState = false;
        this.setOwningNode(nodeReference);
        this.setNext(reference);
        if (this.page == null) {
            this.page = read.groupPage(reference);
        }
        this.read = read;
    }

    public RelationshipGroupCursor.Position suspend() {
        throw new UnsupportedOperationException("not implemented");
    }

    public void resume(RelationshipGroupCursor.Position position) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean next() {
        if (!this.hasCheckedTxState) {
            this.checkTxStateForUpdates();
            this.hasCheckedTxState = true;
        }
        if (this.isBuffered()) {
            this.bufferedGroup = this.bufferedGroup.next;
            if (this.bufferedGroup != null) {
                this.loadFromBuffer();
                return true;
            }
        }
        do {
            if (this.getNext() == -1L) {
                return this.nextFromTxState();
            }
            this.read.group(this, this.getNext(), this.page);
        } while (!this.inUse());
        this.markTypeAsSeen(this.type());
        return true;
    }

    private void loadFromBuffer() {
        this.markTypeAsSeen(this.bufferedGroup.label);
        this.setType(this.bufferedGroup.label);
        this.setFirstOut(this.bufferedGroup.outgoing());
        this.setFirstIn(this.bufferedGroup.incoming());
        this.setFirstLoop(this.bufferedGroup.loops());
    }

    private boolean nextFromTxState() {
        if (this.txTypeIterator == null && !this.txTypes.isEmpty()) {
            this.txTypeIterator = this.txTypes.iterator();
        }
        if (this.txTypeIterator != null && this.txTypeIterator.hasNext()) {
            this.setType(this.txTypeIterator.next());
            this.setFirstOut(-1L);
            this.setFirstIn(-1L);
            this.setFirstLoop(-1L);
            return true;
        }
        return false;
    }

    private void markTypeAsSeen(int type) {
        if (this.txTypes != null) {
            this.txTypes.remove(type);
        }
    }

    private void checkTxStateForUpdates() {
        if (this.read.hasTxStateWithChanges()) {
            NodeState nodeState = this.read.txState().getNodeState(this.getOwningNode());
            PrimitiveLongIterator addedRelationships = nodeState.getAddedRelationships();
            while (addedRelationships.hasNext()) {
                RelationshipState relationshipState = this.read.txState().getRelationshipState(addedRelationships.next());
                relationshipState.accept((relationshipId, typeId, startNodeId, endNodeId) -> this.txTypes.add(typeId));
            }
        }
    }

    public void close() {
        if (!this.isClosed()) {
            this.bufferedGroup = null;
            this.read = null;
            this.setId(-1L);
            this.clear();
            if (this.pool != null) {
                this.pool.accept(this);
            }
        }
    }

    public int type() {
        return this.getType();
    }

    public int outgoingCount() {
        int count = this.isBuffered() ? this.bufferedGroup.outgoingCount : this.count(this.outgoingRawId());
        return this.read.hasTxStateWithChanges() ? this.read.txState().getNodeState(this.getOwningNode()).augmentDegree(RelationshipDirection.OUTGOING, count, this.getType()) : count;
    }

    public int incomingCount() {
        int count = this.isBuffered() ? this.bufferedGroup.incomingCount : this.count(this.incomingRawId());
        return this.read.hasTxStateWithChanges() ? this.read.txState().getNodeState(this.getOwningNode()).augmentDegree(RelationshipDirection.INCOMING, count, this.getType()) : count;
    }

    public int loopCount() {
        int count = this.isBuffered() ? this.bufferedGroup.loopsCount : this.count(this.loopsRawId());
        return this.read.hasTxStateWithChanges() ? this.read.txState().getNodeState(this.getOwningNode()).augmentDegree(RelationshipDirection.LOOP, count, this.getType()) : count;
    }

    private int count(long reference) {
        if (reference == -1L) {
            return 0;
        }
        if (this.edgePage == null) {
            this.edgePage = this.read.relationshipPage(reference);
        }
        this.read.relationship(this.edge, reference, this.edgePage);
        if (this.edge.getFirstNode() == this.getOwningNode()) {
            return (int)this.edge.getFirstPrevRel();
        }
        return (int)this.edge.getSecondPrevRel();
    }

    public void outgoing(RelationshipTraversalCursor cursor) {
        if (this.isBuffered()) {
            ((DefaultRelationshipTraversalCursor)cursor).buffered(this.getOwningNode(), this.bufferedGroup.outgoing, RelationshipDirection.OUTGOING, this.bufferedGroup.label, this.read);
        } else {
            this.read.relationships(this.getOwningNode(), this.outgoingReference(), cursor);
        }
    }

    public void incoming(RelationshipTraversalCursor cursor) {
        if (this.isBuffered()) {
            ((DefaultRelationshipTraversalCursor)cursor).buffered(this.getOwningNode(), this.bufferedGroup.incoming, RelationshipDirection.INCOMING, this.bufferedGroup.label, this.read);
        } else {
            this.read.relationships(this.getOwningNode(), this.incomingReference(), cursor);
        }
    }

    public void loops(RelationshipTraversalCursor cursor) {
        if (this.isBuffered()) {
            ((DefaultRelationshipTraversalCursor)cursor).buffered(this.getOwningNode(), this.bufferedGroup.loops, RelationshipDirection.LOOP, this.bufferedGroup.label, this.read);
        } else {
            this.read.relationships(this.getOwningNode(), this.loopsReference(), cursor);
        }
    }

    public long outgoingReference() {
        long outgoing = this.getFirstOut();
        return outgoing == -1L ? RelationshipReferenceEncoding.encodeNoOutgoingRels(this.getType()) : this.encodeRelationshipReference(outgoing);
    }

    public long incomingReference() {
        long incoming = this.getFirstIn();
        return incoming == -1L ? RelationshipReferenceEncoding.encodeNoIncomingRels(this.getType()) : this.encodeRelationshipReference(incoming);
    }

    public long loopsReference() {
        long loops = this.getFirstLoop();
        return loops == -1L ? RelationshipReferenceEncoding.encodeNoLoopRels(this.getType()) : this.encodeRelationshipReference(loops);
    }

    public boolean isClosed() {
        return this.read == null && this.bufferedGroup == null;
    }

    @Override
    public String toString() {
        if (this.isClosed()) {
            return "RelationshipGroupCursor[closed state]";
        }
        String mode = "mode=";
        mode = this.isBuffered() ? mode + "group" : mode + "direct";
        return "RelationshipGroupCursor[id=" + this.getId() + ", open state with: " + mode + ", underlying record=" + super.toString() + " ]";
    }

    long outgoingRawId() {
        return this.getFirstOut();
    }

    long incomingRawId() {
        return this.getFirstIn();
    }

    long loopsRawId() {
        return this.getFirstLoop();
    }

    private boolean isBuffered() {
        return this.bufferedGroup != null;
    }

    private long encodeRelationshipReference(long relationshipId) {
        assert (relationshipId != -1L);
        return this.isBuffered() ? RelationshipReferenceEncoding.encodeForFiltering(relationshipId) : RelationshipReferenceEncoding.encodeForTxStateFiltering(relationshipId);
    }

    public void release() {
        if (this.edgePage != null) {
            this.edgePage.close();
            this.edgePage = null;
        }
        if (this.page != null) {
            this.page.close();
            this.page = null;
        }
    }

    static class BufferedGroup {
        final int label;
        final BufferedGroup next;
        DefaultRelationshipTraversalCursor.Record outgoing;
        DefaultRelationshipTraversalCursor.Record incoming;
        DefaultRelationshipTraversalCursor.Record loops;
        private long firstOut = -1L;
        private long firstIn = -1L;
        private long firstLoop = -1L;
        int outgoingCount;
        int incomingCount;
        int loopsCount;

        BufferedGroup(RelationshipRecord edge, BufferedGroup next) {
            this.label = edge.getType();
            this.next = next;
        }

        void outgoing(RelationshipRecord edge) {
            if (this.outgoing == null) {
                this.firstOut = edge.getId();
            }
            this.outgoing = new DefaultRelationshipTraversalCursor.Record(edge, this.outgoing);
            ++this.outgoingCount;
        }

        void incoming(RelationshipRecord edge) {
            if (this.incoming == null) {
                this.firstIn = edge.getId();
            }
            this.incoming = new DefaultRelationshipTraversalCursor.Record(edge, this.incoming);
            ++this.incomingCount;
        }

        void loop(RelationshipRecord edge) {
            if (this.loops == null) {
                this.firstLoop = edge.getId();
            }
            this.loops = new DefaultRelationshipTraversalCursor.Record(edge, this.loops);
            ++this.loopsCount;
        }

        long outgoing() {
            return this.firstOut;
        }

        long incoming() {
            return this.firstIn;
        }

        long loops() {
            return this.firstLoop;
        }
    }
}

