/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management;

import java.util.List;
import org.neo4j.jmx.Description;
import org.neo4j.jmx.ManagementInterface;
import org.neo4j.kernel.info.LockInfo;

@ManagementInterface(name="Locking")
@Description(value="Information about the Neo4j lock status")
public interface LockManager {
    public static final String NAME = "Locking";

    @Description(value="The number of lock sequences that would have lead to a deadlock situation that Neo4j has detected and averted (by throwing DeadlockDetectedException).")
    public long getNumberOfAvertedDeadlocks();

    @Description(value="Information about all locks held by Neo4j")
    public List<LockInfo> getLocks();

    @Description(value="Information about contended locks (locks where at least one thread is waiting) held by Neo4j. The parameter is used to get locks where threads have waited for at least the specified number of milliseconds, a value of 0 retrieves all contended locks.")
    public List<LockInfo> getContendedLocks(long var1);
}

