/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.neo4j.jmx.ManagementInterface;
import org.neo4j.management.impl.BeanProxy;

public abstract class KernelProxy {
    static final String KERNEL_BEAN_TYPE = "org.neo4j.jmx.Kernel";
    protected static final String KERNEL_BEAN_NAME = "Kernel";
    static final String MBEAN_QUERY = "MBeanQuery";
    protected final MBeanServerConnection server;
    protected final ObjectName kernel;

    protected KernelProxy(MBeanServerConnection server, ObjectName kernel) {
        String className = null;
        try {
            className = server.getMBeanInfo(kernel).getClassName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!KERNEL_BEAN_TYPE.equals(className)) {
            throw new IllegalArgumentException("The specified ObjectName does not represent a Neo4j Kernel bean in the specified MBean server.");
        }
        this.server = server;
        this.kernel = kernel;
    }

    protected List<Object> allBeans() {
        Set<ObjectInstance> mbeans;
        ArrayList<Object> beans = new ArrayList<Object>();
        try {
            mbeans = this.server.queryMBeans(this.mbeanQuery(), null);
        }
        catch (IOException handled) {
            return beans;
        }
        for (ObjectInstance instance : mbeans) {
            String className = instance.getClassName();
            Class<?> beanType = null;
            try {
                if (className != null) {
                    beanType = Class.forName(className);
                }
            }
            catch (Exception | LinkageError throwable) {
                // empty catch block
            }
            if (beanType == null) continue;
            try {
                beans.add(BeanProxy.load(this.server, beanType, instance.getObjectName()));
            }
            catch (Exception exception) {}
        }
        return beans;
    }

    private ObjectName assertExists(ObjectName name) {
        try {
            if (!this.server.queryNames(name, null).isEmpty()) {
                return name;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new NoSuchElementException("No MBeans matching " + name);
    }

    protected <T> T getBean(Class<T> beanInterface) {
        return BeanProxy.load(this.server, beanInterface, this.createObjectName(beanInterface));
    }

    protected <T> Collection<T> getBeans(Class<T> beanInterface) {
        return BeanProxy.loadAll(this.server, beanInterface, this.createObjectNameQuery(beanInterface));
    }

    private ObjectName createObjectNameQuery(Class<?> beanInterface) {
        return KernelProxy.createObjectNameQuery(this.mbeanQuery(), beanInterface);
    }

    private ObjectName createObjectName(Class<?> beanInterface) {
        return this.assertExists(KernelProxy.createObjectName(this.mbeanQuery(), beanInterface));
    }

    protected ObjectName createObjectName(String beanName) {
        return this.assertExists(KernelProxy.createObjectName(this.mbeanQuery(), beanName, false));
    }

    protected ObjectName mbeanQuery() {
        try {
            return (ObjectName)this.server.getAttribute(this.kernel, MBEAN_QUERY);
        }
        catch (Exception cause) {
            throw new IllegalStateException("Could not get MBean query.", cause);
        }
    }

    protected static ObjectName createObjectName(String kernelIdentifier, Class<?> beanInterface) {
        return KernelProxy.createObjectName(kernelIdentifier, KernelProxy.beanName(beanInterface), new String[0]);
    }

    protected static ObjectName createObjectName(String kernelIdentifier, String beanName, String ... extraNaming) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("instance", "kernel#" + kernelIdentifier);
        return KernelProxy.createObjectName("org.neo4j", properties, beanName, false, extraNaming);
    }

    static ObjectName createObjectNameQuery(String kernelIdentifier, String beanName, String ... extraNaming) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("instance", "kernel#" + kernelIdentifier);
        return KernelProxy.createObjectName("org.neo4j", properties, beanName, true, extraNaming);
    }

    static ObjectName createObjectName(ObjectName query, Class<?> beanInterface) {
        return KernelProxy.createObjectName(query, KernelProxy.beanName(beanInterface), false);
    }

    static ObjectName createObjectNameQuery(ObjectName query, Class<?> beanInterface) {
        return KernelProxy.createObjectName(query, KernelProxy.beanName(beanInterface), true);
    }

    private static ObjectName createObjectName(ObjectName query, String beanName, boolean isQuery) {
        Hashtable<String, String> properties = new Hashtable<String, String>(query.getKeyPropertyList());
        return KernelProxy.createObjectName(query.getDomain(), properties, beanName, isQuery, new String[0]);
    }

    static String beanName(Class<?> beanInterface) {
        ManagementInterface management;
        if (beanInterface.isInterface() && (management = beanInterface.getAnnotation(ManagementInterface.class)) != null) {
            return management.name();
        }
        throw new IllegalArgumentException(beanInterface + " is not a Neo4j Management Been interface");
    }

    private static ObjectName createObjectName(String domain, Hashtable<String, String> properties, String beanName, boolean query, String ... extraNaming) {
        ObjectName result;
        properties.put("name", beanName);
        for (int i = 0; i < extraNaming.length; ++i) {
            properties.put("name" + i, extraNaming[i]);
        }
        try {
            result = new ObjectName(domain, properties);
            if (query) {
                result = ObjectName.getInstance(result.toString() + ",*");
            }
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
        return result;
    }
}

