/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.neo4j.helpers.Strings;
import org.neo4j.kernel.api.query.QuerySnapshot;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.utils.PrettyPrinter;
import org.neo4j.values.virtual.MapValue;

class QueryLogFormatter {
    private QueryLogFormatter() {
    }

    static void formatPageDetails(StringBuilder result, QuerySnapshot query) {
        result.append(query.pageHits()).append(" page hits, ");
        result.append(query.pageFaults()).append(" page faults - ");
    }

    static void formatAllocatedBytes(StringBuilder result, QuerySnapshot query) {
        Long bytes = query.allocatedBytes();
        if (bytes != null) {
            result.append(bytes).append(" B - ");
        }
    }

    static void formatDetailedTime(StringBuilder result, QuerySnapshot query) {
        result.append("(planning: ").append(query.planningTimeMillis());
        Long cpuTime = query.cpuTimeMillis();
        if (cpuTime != null) {
            result.append(", cpu: ").append(cpuTime);
        }
        result.append(", waiting: ").append(query.waitTimeMillis());
        result.append(") - ");
    }

    static void formatMapValue(StringBuilder result, MapValue params) {
        QueryLogFormatter.formatMapValue(result, params, Collections.emptySet());
    }

    static void formatMapValue(StringBuilder result, MapValue params, Collection<String> obfuscate) {
        result.append('{');
        if (params != null) {
            String sep = "";
            for (Map.Entry entry : params.entrySet()) {
                result.append(sep).append((String)entry.getKey()).append(": ");
                if (obfuscate.contains(entry.getKey())) {
                    result.append("******");
                } else {
                    result.append(QueryLogFormatter.formatAnyValue((AnyValue)entry.getValue()));
                }
                sep = ", ";
            }
        }
        result.append("}");
    }

    static String formatAnyValue(AnyValue value) {
        PrettyPrinter printer = new PrettyPrinter("'");
        value.writeTo((AnyValueWriter)printer);
        return printer.value();
    }

    static void formatMap(StringBuilder result, Map<String, Object> params) {
        QueryLogFormatter.formatMap(result, params, Collections.emptySet());
    }

    static void formatMap(StringBuilder result, Map<String, Object> params, Collection<String> obfuscate) {
        result.append('{');
        if (params != null) {
            String sep = "";
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                result.append(sep).append(entry.getKey()).append(": ");
                if (obfuscate.contains(entry.getKey())) {
                    result.append("******");
                } else {
                    QueryLogFormatter.formatValue(result, entry.getValue());
                }
                sep = ", ";
            }
        }
        result.append("}");
    }

    private static void formatValue(StringBuilder result, Object value) {
        if (value instanceof Map) {
            QueryLogFormatter.formatMapValue(result, (MapValue)value);
        } else if (value instanceof String) {
            result.append('\'').append(value).append('\'');
        } else {
            result.append(Strings.prettyPrint((Object)value));
        }
    }
}

