/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth.plugin;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.crypto.hash.SimpleHash;
import org.apache.shiro.util.ByteSource;
import org.neo4j.internal.kernel.api.security.AuthenticationResult;
import org.neo4j.server.security.enterprise.auth.SecureHasher;
import org.neo4j.server.security.enterprise.auth.ShiroAuthenticationInfo;
import org.neo4j.server.security.enterprise.auth.plugin.spi.AuthInfo;
import org.neo4j.server.security.enterprise.auth.plugin.spi.CacheableAuthInfo;

public class PluginAuthInfo
extends ShiroAuthenticationInfo
implements AuthorizationInfo {
    Set<String> roles;

    private PluginAuthInfo(Object principal, String realmName, Set<String> roles) {
        super(principal, realmName, AuthenticationResult.SUCCESS);
        this.roles = roles;
    }

    private PluginAuthInfo(Object principal, Object hashedCredentials, ByteSource credentialsSalt, String realmName, Set<String> roles) {
        super(principal, hashedCredentials, credentialsSalt, realmName, AuthenticationResult.SUCCESS);
        this.roles = roles;
    }

    private PluginAuthInfo(AuthInfo authInfo, SimpleHash hashedCredentials, String realmName) {
        this(authInfo.principal(), (Object)hashedCredentials.getBytes(), hashedCredentials.getSalt(), realmName, new HashSet<String>(authInfo.roles()));
    }

    public static PluginAuthInfo create(AuthInfo authInfo, String realmName) {
        return new PluginAuthInfo(authInfo.principal(), realmName, new HashSet<String>(authInfo.roles()));
    }

    public static PluginAuthInfo createCacheable(AuthInfo authInfo, String realmName, SecureHasher secureHasher) {
        if (authInfo instanceof CacheableAuthInfo) {
            byte[] credentials = ((CacheableAuthInfo)authInfo).credentials();
            SimpleHash hashedCredentials = secureHasher.hash(credentials);
            return new PluginAuthInfo(authInfo, hashedCredentials, realmName);
        }
        return new PluginAuthInfo(authInfo.principal(), realmName, new HashSet<String>(authInfo.roles()));
    }

    public Collection<String> getRoles() {
        return this.roles;
    }

    public Collection<String> getStringPermissions() {
        return Collections.emptyList();
    }

    public Collection<Permission> getObjectPermissions() {
        return Collections.emptyList();
    }
}

