package org.openqa.selenium.devtools.v103.accessibility.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * A single source for a computed AX property.
 */
public class AXValueSource {

    private final org.openqa.selenium.devtools.v103.accessibility.model.AXValueSourceType type;

    private final java.util.Optional<org.openqa.selenium.devtools.v103.accessibility.model.AXValue> value;

    private final java.util.Optional<java.lang.String> attribute;

    private final java.util.Optional<org.openqa.selenium.devtools.v103.accessibility.model.AXValue> attributeValue;

    private final java.util.Optional<java.lang.Boolean> superseded;

    private final java.util.Optional<org.openqa.selenium.devtools.v103.accessibility.model.AXValueNativeSourceType> nativeSource;

    private final java.util.Optional<org.openqa.selenium.devtools.v103.accessibility.model.AXValue> nativeSourceValue;

    private final java.util.Optional<java.lang.Boolean> invalid;

    private final java.util.Optional<java.lang.String> invalidReason;

    public AXValueSource(org.openqa.selenium.devtools.v103.accessibility.model.AXValueSourceType type, java.util.Optional<org.openqa.selenium.devtools.v103.accessibility.model.AXValue> value, java.util.Optional<java.lang.String> attribute, java.util.Optional<org.openqa.selenium.devtools.v103.accessibility.model.AXValue> attributeValue, java.util.Optional<java.lang.Boolean> superseded, java.util.Optional<org.openqa.selenium.devtools.v103.accessibility.model.AXValueNativeSourceType> nativeSource, java.util.Optional<org.openqa.selenium.devtools.v103.accessibility.model.AXValue> nativeSourceValue, java.util.Optional<java.lang.Boolean> invalid, java.util.Optional<java.lang.String> invalidReason) {
        this.type = java.util.Objects.requireNonNull(type, "type is required");
        this.value = value;
        this.attribute = attribute;
        this.attributeValue = attributeValue;
        this.superseded = superseded;
        this.nativeSource = nativeSource;
        this.nativeSourceValue = nativeSourceValue;
        this.invalid = invalid;
        this.invalidReason = invalidReason;
    }

    /**
     * What type of source this is.
     */
    public org.openqa.selenium.devtools.v103.accessibility.model.AXValueSourceType getType() {
        return type;
    }

    /**
     * The value of this property source.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v103.accessibility.model.AXValue> getValue() {
        return value;
    }

    /**
     * The name of the relevant attribute, if any.
     */
    public java.util.Optional<java.lang.String> getAttribute() {
        return attribute;
    }

    /**
     * The value of the relevant attribute, if any.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v103.accessibility.model.AXValue> getAttributeValue() {
        return attributeValue;
    }

    /**
     * Whether this source is superseded by a higher priority source.
     */
    public java.util.Optional<java.lang.Boolean> getSuperseded() {
        return superseded;
    }

    /**
     * The native markup source for this value, e.g. a <label> element.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v103.accessibility.model.AXValueNativeSourceType> getNativeSource() {
        return nativeSource;
    }

    /**
     * The value, such as a node or node list, of the native source.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v103.accessibility.model.AXValue> getNativeSourceValue() {
        return nativeSourceValue;
    }

    /**
     * Whether the value for this property is invalid.
     */
    public java.util.Optional<java.lang.Boolean> getInvalid() {
        return invalid;
    }

    /**
     * Reason for the value being invalid, if it is.
     */
    public java.util.Optional<java.lang.String> getInvalidReason() {
        return invalidReason;
    }

    private static AXValueSource fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v103.accessibility.model.AXValueSourceType type = null;
        java.util.Optional<org.openqa.selenium.devtools.v103.accessibility.model.AXValue> value = java.util.Optional.empty();
        java.util.Optional<java.lang.String> attribute = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v103.accessibility.model.AXValue> attributeValue = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> superseded = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v103.accessibility.model.AXValueNativeSourceType> nativeSource = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v103.accessibility.model.AXValue> nativeSourceValue = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> invalid = java.util.Optional.empty();
        java.util.Optional<java.lang.String> invalidReason = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "type":
                    type = input.read(org.openqa.selenium.devtools.v103.accessibility.model.AXValueSourceType.class);
                    break;
                case "value":
                    value = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v103.accessibility.model.AXValue.class));
                    break;
                case "attribute":
                    attribute = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "attributeValue":
                    attributeValue = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v103.accessibility.model.AXValue.class));
                    break;
                case "superseded":
                    superseded = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "nativeSource":
                    nativeSource = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v103.accessibility.model.AXValueNativeSourceType.class));
                    break;
                case "nativeSourceValue":
                    nativeSourceValue = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v103.accessibility.model.AXValue.class));
                    break;
                case "invalid":
                    invalid = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "invalidReason":
                    invalidReason = java.util.Optional.ofNullable(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new AXValueSource(type, value, attribute, attributeValue, superseded, nativeSource, nativeSourceValue, invalid, invalidReason);
    }
}
