/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.content.memory;

import java.io.IOException;
import org.sitemesh.content.Content;
import org.sitemesh.content.ContentChunk;
import org.sitemesh.tagprocessor.CharSequenceBuffer;

class InMemoryContentChunk
implements ContentChunk {
    private CharSequence value;
    private final Content owner;

    public InMemoryContentChunk(Content owner) {
        this.owner = owner;
    }

    @Override
    public boolean hasValue() {
        return this.value != null;
    }

    @Override
    public String getValue() {
        return this.value != null ? this.value.toString() : null;
    }

    @Override
    public String getNonNullValue() {
        return this.value != null ? this.value.toString() : "";
    }

    @Override
    public void writeValueTo(Appendable out) throws IOException {
        if (this.value == null) {
            return;
        }
        if (this.value instanceof CharSequenceBuffer) {
            ((CharSequenceBuffer)this.value).writeTo(out);
        } else {
            out.append(this.value);
        }
    }

    @Override
    public void setValue(CharSequence value) {
        this.value = value;
    }

    public String toString() {
        return this.getNonNullValue();
    }

    @Override
    public Content getOwningContent() {
        return this.owner;
    }
}

