/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.tagprocessor;

import java.io.IOException;
import org.sitemesh.tagprocessor.BasicRule;
import org.sitemesh.tagprocessor.Tag;

public abstract class BasicBlockRule<T>
extends BasicRule {
    private DataHolder<T> current;

    protected abstract T processStart(Tag var1) throws IOException;

    protected abstract void processEnd(Tag var1, T var2) throws IOException;

    @Override
    public void process(Tag tag) throws IOException {
        switch (tag.getType()) {
            case OPEN: {
                T data = this.processStart(tag);
                this.current = new DataHolder<T>(data, this.current);
                break;
            }
            case CLOSE: {
                if (this.current == null) break;
                this.processEnd(tag, this.current.getData());
                this.current = this.current.getPrevious();
                break;
            }
            case EMPTY: {
                T data = this.processStart(tag);
                this.processEnd(tag, data);
                break;
            }
        }
    }

    private static class DataHolder<T> {
        private final T data;
        private final DataHolder<T> previous;

        public DataHolder(T data, DataHolder<T> previous) {
            this.data = data;
            this.previous = previous;
        }

        public T getData() {
            return this.data;
        }

        public DataHolder<T> getPrevious() {
            return this.previous;
        }
    }
}

