/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.webapp;

import java.io.IOException;
import java.io.Writer;
import java.nio.CharBuffer;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sitemesh.BaseSiteMeshContext;
import org.sitemesh.SiteMeshContext;
import org.sitemesh.config.PathMapper;
import org.sitemesh.content.Content;
import org.sitemesh.content.ContentProcessor;
import org.sitemesh.webapp.contentfilter.BasicSelector;
import org.sitemesh.webapp.contentfilter.HttpServletRequestFilterable;
import org.sitemesh.webapp.contentfilter.HttpServletResponseBuffer;
import org.sitemesh.webapp.contentfilter.ResponseMetaData;

public class WebAppContext
extends BaseSiteMeshContext {
    public static final String CONTENT_KEY = Content.class.getName();
    public static final String CONTEXT_KEY = SiteMeshContext.class.getName();
    private final String contentType;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final ServletContext servletContext;
    private final ResponseMetaData metaData;
    private final boolean includeErrorPages;

    public WebAppContext(String contentType, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, ContentProcessor contentProcessor, ResponseMetaData metaData, boolean includeErrorPages) {
        super(contentProcessor);
        this.contentType = contentType;
        this.request = request;
        this.response = response;
        this.servletContext = servletContext;
        this.metaData = metaData;
        this.includeErrorPages = includeErrorPages;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getPath() {
        return WebAppContext.getRequestPath(this.request);
    }

    public static String getRequestPath(HttpServletRequest request) {
        String result = request.getServletPath();
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            result = result + pathInfo;
        }
        if (result == null) {
            String requestURI = request.getRequestURI();
            if (request.getPathInfo() != null) {
                return requestURI.substring(0, requestURI.indexOf(request.getPathInfo()));
            }
            return requestURI;
        }
        if ("".equals(result)) {
            return request.getPathInfo();
        }
        return result;
    }

    @Override
    protected void decorate(String decoratorPath, Content content, Writer out) throws IOException {
        HttpServletRequestFilterable filterableRequest = new HttpServletRequestFilterable(this.request);
        HttpServletResponseBuffer responseBuffer = new HttpServletResponseBuffer(this.response, this.metaData, new BasicSelector(new PathMapper(), this.includeErrorPages, new String[0]){

            @Override
            public boolean shouldBufferForContentType(String contentType, String mimeType, String encoding) {
                return true;
            }
        });
        responseBuffer.setContentType(this.response.getContentType());
        Object oldContent = this.request.getAttribute(CONTENT_KEY);
        Object oldContext = this.request.getAttribute(CONTEXT_KEY);
        this.request.setAttribute(CONTENT_KEY, (Object)content);
        this.request.setAttribute(CONTEXT_KEY, (Object)this);
        try {
            this.dispatch((HttpServletRequest)filterableRequest, (HttpServletResponse)responseBuffer, decoratorPath);
            CharBuffer buffer = responseBuffer.getBuffer();
            out.append(buffer);
        }
        catch (ServletException e) {
            throw (IOException)new IOException("Could not dispatch to decorator").initCause(e);
        }
        finally {
            this.request.setAttribute(CONTENT_KEY, oldContent);
            this.request.setAttribute(CONTEXT_KEY, oldContext);
        }
    }

    protected void dispatch(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException, IOException {
        RequestDispatcher dispatcher = this.servletContext.getRequestDispatcher(path);
        if (dispatcher == null) {
            throw new ServletException("Not found: " + path);
        }
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }
}

