/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.webapp.contentfilter;

import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class HttpServletRequestFilterable
extends HttpServletRequestWrapper {
    protected Set<String> exclusionsHeaders = new HashSet<String>();

    public HttpServletRequestFilterable(HttpServletRequest httpServletRequest) {
        super(httpServletRequest);
        this.addExclusion("If-Modified-Since");
    }

    public String getHeader(String header) {
        if (this.isExcluded(header)) {
            return null;
        }
        return super.getHeader(header);
    }

    public long getDateHeader(String header) {
        if (this.isExcluded(header)) {
            return -1L;
        }
        return super.getDateHeader(header);
    }

    protected boolean isExcluded(String header) {
        return this.exclusionsHeaders.contains(this.normalize(header));
    }

    protected String normalize(String header) {
        return header.toLowerCase();
    }

    public void addExclusion(String header) {
        if (header == null) {
            throw new IllegalArgumentException("The header value can not be null.");
        }
        this.exclusionsHeaders.add(this.normalize(header));
    }
}

