/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.config.cmdline;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ArgParser {
    private final Map<String, String> properties = new HashMap<String, String>();
    private final List<String> remaining = new ArrayList<String>();

    public ArgParser(String ... args) throws IllegalArgumentException {
        String currentKey = null;
        for (String arg : args) {
            if (currentKey != null) {
                this.properties.put(currentKey, arg);
                currentKey = null;
                continue;
            }
            if (arg.startsWith("-")) {
                if (!this.remaining.isEmpty()) {
                    throw new IllegalArgumentException("Parameters have to appear first.");
                }
                String token = arg.substring(arg.startsWith("--") ? 2 : 1);
                int equals = token.indexOf(61);
                if (equals > -1) {
                    this.properties.put(token.substring(0, equals), token.substring(equals + 1));
                    continue;
                }
                currentKey = token;
                continue;
            }
            this.remaining.add(arg);
        }
        if (currentKey != null) {
            throw new IllegalArgumentException("Parameter '" + currentKey + "' does not have value associated.");
        }
    }

    public Map<String, String> getProperties() {
        return new HashMap<String, String>(this.properties);
    }

    public List<String> getRemaining() {
        return new ArrayList<String>(this.remaining);
    }
}

