/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.config.properties;

import java.util.Map;
import org.sitemesh.DecoratorSelector;
import org.sitemesh.builder.BaseSiteMeshFilterBuilder;
import org.sitemesh.config.ObjectFactory;
import org.sitemesh.config.properties.PropertiesConfigurator;
import org.sitemesh.config.properties.PropertiesParser;

public class PropertiesFilterConfigurator
extends PropertiesConfigurator {
    public static final String EXCLUDE_PARAM = "exclude";
    public static final String MIME_TYPES_PARAM = "mimeTypes";
    public static final String INCLUDE_ERROR_PAGES_PARAM = "includeErrorPages";
    public static final String DECORATOR_SELECTOR = "decoratorSelector";
    private final PropertiesParser properties;

    public PropertiesFilterConfigurator(ObjectFactory objectFactory, Map<String, String> properties) {
        super(objectFactory, properties);
        this.properties = new PropertiesParser(properties);
    }

    public void configureFilter(BaseSiteMeshFilterBuilder builder) {
        String[] excludes;
        String decoratorSelector;
        this.configureCommon(builder);
        String includeErrorPagesString = this.properties.getString(INCLUDE_ERROR_PAGES_PARAM);
        if ("true".equals(includeErrorPagesString) || "1".equals(includeErrorPagesString)) {
            builder.setIncludeErrorPages(true);
        }
        if ((decoratorSelector = this.properties.getString(DECORATOR_SELECTOR)) != null) {
            builder.setCustomDecoratorSelector((DecoratorSelector)this.getObjectFactory().create(decoratorSelector));
        }
        for (String exclude : excludes = this.properties.getStringArray(EXCLUDE_PARAM)) {
            builder.addExcludedPath(exclude);
        }
        String[] mimeTypes = this.properties.getStringArray(MIME_TYPES_PARAM);
        if (mimeTypes.length > 0) {
            builder.setMimeTypes(mimeTypes);
        }
    }
}

