/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.offline;

import java.io.IOException;
import java.nio.CharBuffer;
import org.sitemesh.DecoratorSelector;
import org.sitemesh.content.Content;
import org.sitemesh.content.ContentProcessor;
import org.sitemesh.offline.OfflineContext;
import org.sitemesh.offline.directory.Directory;

public class SiteMeshOffline {
    private final ContentProcessor contentProcessor;
    private final DecoratorSelector<OfflineContext> decoratorSelector;
    private final Directory sourceDirectory;
    private final Directory destinationDirectory;

    public SiteMeshOffline(ContentProcessor contentProcessor, DecoratorSelector<OfflineContext> decoratorSelector, Directory sourceDirectory, Directory destinationDirectory) {
        this.contentProcessor = contentProcessor;
        this.decoratorSelector = decoratorSelector;
        this.sourceDirectory = sourceDirectory;
        this.destinationDirectory = destinationDirectory;
    }

    public Directory getSourceDirectory() {
        return this.sourceDirectory;
    }

    public Directory getDestinationDirectory() {
        return this.destinationDirectory;
    }

    public void process(String path) throws IOException {
        CharBuffer input = this.sourceDirectory.load(path);
        CharBuffer output = this.processContent(path, input);
        this.destinationDirectory.save(path, output);
    }

    public CharBuffer processContent(String path, CharBuffer original) throws IOException {
        String[] decoratorPaths;
        OfflineContext context = new OfflineContext(this.contentProcessor, this.sourceDirectory, path);
        Content content = this.contentProcessor.build(original, context);
        if (content == null) {
            return original;
        }
        for (String decoratorPath : decoratorPaths = this.decoratorSelector.selectDecoratorPaths(content, context)) {
            content = context.decorate(decoratorPath, content);
        }
        if (content == null) {
            return original;
        }
        StringBuilder out = new StringBuilder();
        content.getData().writeValueTo(out);
        return CharBuffer.wrap(out.toString());
    }
}

