/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.webapp.contentfilter;

import javax.servlet.http.HttpServletRequest;
import org.sitemesh.config.PathMapper;
import org.sitemesh.webapp.WebAppContext;
import org.sitemesh.webapp.contentfilter.Selector;

public class BasicSelector
implements Selector {
    private static final String ALREADY_APPLIED_KEY = BasicSelector.class.getName() + ".APPLIED_ONCE";
    private final String[] mimeTypesToBuffer;
    private final boolean includeErrorPages;
    private final PathMapper<Boolean> excludesMapper;

    public BasicSelector(String ... mimeTypesToBuffer) {
        this(new PathMapper<Boolean>(), false, mimeTypesToBuffer);
    }

    public BasicSelector(PathMapper<Boolean> excludesMapper, String ... mimeTypesToBuffer) {
        this(excludesMapper, false, mimeTypesToBuffer);
    }

    public BasicSelector(boolean includeErrorPages, String ... mimeTypesToBuffer) {
        this(new PathMapper<Boolean>(), includeErrorPages, mimeTypesToBuffer);
    }

    public BasicSelector(PathMapper<Boolean> excludesMapper, boolean includeErrorPages, String ... mimeTypesToBuffer) {
        this.mimeTypesToBuffer = mimeTypesToBuffer;
        this.includeErrorPages = includeErrorPages;
        this.excludesMapper = excludesMapper;
    }

    @Override
    public boolean shouldBufferForContentType(String contentType, String mimeType, String encoding) {
        if (mimeType == null) {
            return false;
        }
        for (String mimeTypeToBuffer : this.mimeTypesToBuffer) {
            if (!mimeTypeToBuffer.equalsIgnoreCase(mimeType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldAbortBufferingForHttpStatusCode(int statusCode) {
        return statusCode != 200 && (!this.includeErrorPages || statusCode < 400);
    }

    @Override
    public boolean shouldBufferForRequest(HttpServletRequest request) {
        return !this.filterAlreadyAppliedForRequest(request);
    }

    protected boolean filterAlreadyAppliedForRequest(HttpServletRequest request) {
        if (Boolean.TRUE.equals(request.getAttribute(ALREADY_APPLIED_KEY))) {
            return true;
        }
        request.setAttribute(ALREADY_APPLIED_KEY, (Object)true);
        return false;
    }

    @Override
    public String excludePatternInUse(HttpServletRequest request) {
        return this.excludesMapper.getPatternInUse(WebAppContext.getRequestPath(request));
    }
}

