/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.spockframework.runtime.InvalidSpecException;
import org.spockframework.runtime.RunContext;
import org.spockframework.runtime.SpecRunHistory;
import org.spockframework.runtime.model.FeatureMetadata;
import org.spockframework.runtime.model.SpecMetadata;
import spock.lang.Specification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpecUtil {
    private SpecUtil() {
    }

    public static boolean isSpec(Class<?> clazz) {
        return clazz.isAnnotationPresent(SpecMetadata.class);
    }

    public static void checkIsSpec(Class<?> clazz) {
        if (SpecUtil.isSpec(clazz)) {
            return;
        }
        if (Specification.class.isAssignableFrom(clazz)) {
            throw new InvalidSpecException("Specification '%s' was not compiled properly (Spock AST transform was not run); try to do a clean build").withArgs(clazz.getName());
        }
        throw new InvalidSpecException("Class '%s' is not a Spock specification (does not extend spock.lang.Specification or a subclass thereof)").withArgs(clazz.getName());
    }

    public static boolean isRunnableSpec(Class<?> clazz) {
        return SpecUtil.isSpec(clazz) && !Modifier.isAbstract(clazz.getModifiers());
    }

    public static void checkIsRunnableSpec(Class<?> clazz) {
        SpecUtil.checkIsSpec(clazz);
        if (Modifier.isAbstract(clazz.getModifiers())) {
            throw new InvalidSpecException("Specification '%s' is not runnable because it is declared abstract").withArgs(clazz.getName());
        }
    }

    public static int getFeatureCount(Class<?> spec) {
        SpecUtil.checkIsSpec(spec);
        int count = 0;
        do {
            for (Method method : spec.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(FeatureMetadata.class)) continue;
                ++count;
            }
        } while ((spec = spec.getSuperclass()) != null && SpecUtil.isSpec(spec));
        return count;
    }

    public static List<String> optimizeRunOrder(List<String> specNames) {
        List<SpecRunHistory> histories = SpecUtil.loadHistories(specNames);
        Collections.sort(histories);
        return SpecUtil.extractNames(histories);
    }

    public static <T> T getConfiguration(Class<T> type) {
        return RunContext.get().getConfiguration(type);
    }

    private static List<SpecRunHistory> loadHistories(List<String> specNames) {
        ArrayList<SpecRunHistory> histories = new ArrayList<SpecRunHistory>(specNames.size());
        for (String name : specNames) {
            SpecRunHistory history = new SpecRunHistory(name);
            try {
                history.loadFromDisk();
            }
            catch (IOException ignored) {
                // empty catch block
            }
            histories.add(history);
        }
        return histories;
    }

    private static List<String> extractNames(List<SpecRunHistory> histories) {
        ArrayList<String> specNames = new ArrayList<String>(histories.size());
        for (SpecRunHistory history : histories) {
            specNames.add(history.getSpecName());
        }
        return specNames;
    }
}

