/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.util.List;
import org.junit.runners.model.Statement;
import org.spockframework.runtime.extension.ExtensionException;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.model.FieldInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRuleInterceptor
implements IMethodInterceptor {
    protected final List<FieldInfo> ruleFields;

    public AbstractRuleInterceptor(List<FieldInfo> ruleFields) {
        this.ruleFields = ruleFields;
    }

    protected Statement createBaseStatement(final IMethodInvocation invocation) {
        return new Statement(){

            public void evaluate() throws Throwable {
                invocation.proceed();
            }
        };
    }

    protected Object getRuleInstance(FieldInfo field, Object fieldTarget) {
        Object rule = field.readValue(fieldTarget);
        if (rule == null) {
            try {
                rule = field.getType().newInstance();
                field.writeValue(fieldTarget, rule);
            }
            catch (Exception e) {
                throw new ExtensionException("Auto-instantiating @Rule field '%s' failed. You may have to instantiate it manually.", e).withArgs(field.getName());
            }
        }
        return rule;
    }
}

