/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core.http.converter;

import java.net.URL;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.security.oauth2.core.OAuth2TokenIntrospection;
import org.springframework.security.oauth2.core.converter.ClaimConversionService;
import org.springframework.security.oauth2.core.converter.ClaimTypeConverter;
import org.springframework.security.oauth2.core.http.converter.HttpMessageConverters;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class OAuth2TokenIntrospectionHttpMessageConverter
extends AbstractHttpMessageConverter<OAuth2TokenIntrospection> {
    private static final ParameterizedTypeReference<Map<String, Object>> STRING_OBJECT_MAP = new ParameterizedTypeReference<Map<String, Object>>(){};
    private final GenericHttpMessageConverter<Object> jsonMessageConverter = HttpMessageConverters.getJsonMessageConverter();
    private Converter<Map<String, Object>, OAuth2TokenIntrospection> tokenIntrospectionConverter = new MapOAuth2TokenIntrospectionConverter();
    private Converter<OAuth2TokenIntrospection, Map<String, Object>> tokenIntrospectionParametersConverter = new OAuth2TokenIntrospectionMapConverter();

    public OAuth2TokenIntrospectionHttpMessageConverter() {
        super(new MediaType[]{MediaType.APPLICATION_JSON, new MediaType("application", "*+json")});
    }

    protected boolean supports(Class<?> clazz) {
        return OAuth2TokenIntrospection.class.isAssignableFrom(clazz);
    }

    protected OAuth2TokenIntrospection readInternal(Class<? extends OAuth2TokenIntrospection> clazz, HttpInputMessage inputMessage) throws HttpMessageNotReadableException {
        try {
            Map tokenIntrospectionParameters = (Map)this.jsonMessageConverter.read(STRING_OBJECT_MAP.getType(), null, inputMessage);
            return (OAuth2TokenIntrospection)this.tokenIntrospectionConverter.convert((Object)tokenIntrospectionParameters);
        }
        catch (Exception ex) {
            throw new HttpMessageNotReadableException("An error occurred reading the Token Introspection Response: " + ex.getMessage(), (Throwable)ex, inputMessage);
        }
    }

    protected void writeInternal(OAuth2TokenIntrospection tokenIntrospection, HttpOutputMessage outputMessage) throws HttpMessageNotWritableException {
        try {
            Map tokenIntrospectionResponseParameters = (Map)this.tokenIntrospectionParametersConverter.convert((Object)tokenIntrospection);
            this.jsonMessageConverter.write((Object)tokenIntrospectionResponseParameters, STRING_OBJECT_MAP.getType(), MediaType.APPLICATION_JSON, outputMessage);
        }
        catch (Exception ex) {
            throw new HttpMessageNotWritableException("An error occurred writing the Token Introspection Response: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public final void setTokenIntrospectionConverter(Converter<Map<String, Object>, OAuth2TokenIntrospection> tokenIntrospectionConverter) {
        Assert.notNull(tokenIntrospectionConverter, (String)"tokenIntrospectionConverter cannot be null");
        this.tokenIntrospectionConverter = tokenIntrospectionConverter;
    }

    public final void setTokenIntrospectionParametersConverter(Converter<OAuth2TokenIntrospection, Map<String, Object>> tokenIntrospectionParametersConverter) {
        Assert.notNull(tokenIntrospectionParametersConverter, (String)"tokenIntrospectionParametersConverter cannot be null");
        this.tokenIntrospectionParametersConverter = tokenIntrospectionParametersConverter;
    }

    private static final class OAuth2TokenIntrospectionMapConverter
    implements Converter<OAuth2TokenIntrospection, Map<String, Object>> {
        private OAuth2TokenIntrospectionMapConverter() {
        }

        public Map<String, Object> convert(OAuth2TokenIntrospection source) {
            LinkedHashMap<String, Object> responseClaims = new LinkedHashMap<String, Object>(source.getClaims());
            if (!CollectionUtils.isEmpty((Collection)source.getScopes())) {
                responseClaims.put("scope", StringUtils.collectionToDelimitedString((Collection)source.getScopes(), (String)" "));
            }
            if (source.getExpiresAt() != null) {
                responseClaims.put("exp", source.getExpiresAt().getEpochSecond());
            }
            if (source.getIssuedAt() != null) {
                responseClaims.put("iat", source.getIssuedAt().getEpochSecond());
            }
            if (source.getNotBefore() != null) {
                responseClaims.put("nbf", source.getNotBefore().getEpochSecond());
            }
            return responseClaims;
        }
    }

    private static final class MapOAuth2TokenIntrospectionConverter
    implements Converter<Map<String, Object>, OAuth2TokenIntrospection> {
        private static final ClaimConversionService CLAIM_CONVERSION_SERVICE = ClaimConversionService.getSharedInstance();
        private static final TypeDescriptor OBJECT_TYPE_DESCRIPTOR = TypeDescriptor.valueOf(Object.class);
        private static final TypeDescriptor BOOLEAN_TYPE_DESCRIPTOR = TypeDescriptor.valueOf(Boolean.class);
        private static final TypeDescriptor STRING_TYPE_DESCRIPTOR = TypeDescriptor.valueOf(String.class);
        private static final TypeDescriptor INSTANT_TYPE_DESCRIPTOR = TypeDescriptor.valueOf(Instant.class);
        private static final TypeDescriptor URL_TYPE_DESCRIPTOR = TypeDescriptor.valueOf(URL.class);
        private final ClaimTypeConverter claimTypeConverter;

        private MapOAuth2TokenIntrospectionConverter() {
            Converter<Object, ?> booleanConverter = MapOAuth2TokenIntrospectionConverter.getConverter(BOOLEAN_TYPE_DESCRIPTOR);
            Converter<Object, ?> stringConverter = MapOAuth2TokenIntrospectionConverter.getConverter(STRING_TYPE_DESCRIPTOR);
            Converter<Object, ?> instantConverter = MapOAuth2TokenIntrospectionConverter.getConverter(INSTANT_TYPE_DESCRIPTOR);
            Converter<Object, ?> collectionStringConverter = MapOAuth2TokenIntrospectionConverter.getConverter(TypeDescriptor.collection(Collection.class, (TypeDescriptor)STRING_TYPE_DESCRIPTOR));
            Converter<Object, ?> urlConverter = MapOAuth2TokenIntrospectionConverter.getConverter(URL_TYPE_DESCRIPTOR);
            HashMap<String, Object> claimConverters = new HashMap<String, Object>();
            claimConverters.put("active", booleanConverter);
            claimConverters.put("scope", MapOAuth2TokenIntrospectionConverter::convertScope);
            claimConverters.put("client_id", stringConverter);
            claimConverters.put("username", stringConverter);
            claimConverters.put("token_type", stringConverter);
            claimConverters.put("exp", instantConverter);
            claimConverters.put("iat", instantConverter);
            claimConverters.put("nbf", instantConverter);
            claimConverters.put("sub", stringConverter);
            claimConverters.put("aud", collectionStringConverter);
            claimConverters.put("iss", urlConverter);
            claimConverters.put("jti", stringConverter);
            this.claimTypeConverter = new ClaimTypeConverter(claimConverters);
        }

        public OAuth2TokenIntrospection convert(Map<String, Object> source) {
            Map parsedClaims = this.claimTypeConverter.convert(source);
            return OAuth2TokenIntrospection.withClaims(parsedClaims).build();
        }

        private static Converter<Object, ?> getConverter(TypeDescriptor targetDescriptor) {
            return source -> CLAIM_CONVERSION_SERVICE.convert(source, OBJECT_TYPE_DESCRIPTOR, targetDescriptor);
        }

        private static List<String> convertScope(Object scope) {
            if (scope == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(StringUtils.delimitedListToStringArray((String)scope.toString(), (String)" "));
        }
    }
}

