/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.oidc.authentication;

import java.util.Map;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.authentication.OAuth2AuthenticationContext;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcUserInfoAuthenticationToken;
import org.springframework.util.Assert;

public final class OidcUserInfoAuthenticationContext
extends OAuth2AuthenticationContext {
    private OidcUserInfoAuthenticationContext(Map<Object, Object> context) {
        super(context);
    }

    public OAuth2AccessToken getAccessToken() {
        return this.get(OAuth2AccessToken.class);
    }

    public OAuth2Authorization getAuthorization() {
        return this.get(OAuth2Authorization.class);
    }

    public static Builder with(OidcUserInfoAuthenticationToken authentication) {
        return new Builder(authentication);
    }

    public static final class Builder
    extends OAuth2AuthenticationContext.AbstractBuilder<OidcUserInfoAuthenticationContext, Builder> {
        private Builder(OidcUserInfoAuthenticationToken authentication) {
            super((Authentication)authentication);
        }

        public Builder accessToken(OAuth2AccessToken accessToken) {
            return (Builder)this.put(OAuth2AccessToken.class, accessToken);
        }

        public Builder authorization(OAuth2Authorization authorization) {
            return (Builder)this.put(OAuth2Authorization.class, authorization);
        }

        @Override
        public OidcUserInfoAuthenticationContext build() {
            Assert.notNull(this.get(OAuth2AccessToken.class), (String)"accessToken cannot be null");
            Assert.notNull(this.get(OAuth2Authorization.class), (String)"authorization cannot be null");
            return new OidcUserInfoAuthenticationContext(this.getContext());
        }
    }
}

