/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.LookupOverride;
import org.springframework.beans.factory.support.MethodOverride;
import org.springframework.beans.factory.support.MethodReplacer;
import org.springframework.beans.factory.support.ReplaceOverride;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.support.SimpleInstantiationStrategy;
import org.springframework.cglib.core.NamingPolicy;
import org.springframework.cglib.core.SpringNamingPolicy;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.CallbackFilter;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.Factory;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.cglib.proxy.NoOp;

public class CglibSubclassingInstantiationStrategy
extends SimpleInstantiationStrategy {
    private static final int PASSTHROUGH = 0;
    private static final int LOOKUP_OVERRIDE = 1;
    private static final int METHOD_REPLACER = 2;

    @Override
    protected Object instantiateWithMethodInjection(RootBeanDefinition beanDefinition, String beanName, BeanFactory owner) {
        return this.instantiateWithMethodInjection(beanDefinition, beanName, owner, null, null);
    }

    @Override
    protected Object instantiateWithMethodInjection(RootBeanDefinition beanDefinition, String beanName, BeanFactory owner, Constructor<?> ctor, Object[] args) {
        return new CglibSubclassCreator(beanDefinition, owner).instantiate(ctor, args);
    }

    private static class ReplaceOverrideMethodInterceptor
    extends CglibIdentitySupport
    implements MethodInterceptor {
        private final BeanFactory owner;

        ReplaceOverrideMethodInterceptor(RootBeanDefinition beanDefinition, BeanFactory owner) {
            super(beanDefinition);
            this.owner = owner;
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy mp) throws Throwable {
            ReplaceOverride ro = (ReplaceOverride)this.getBeanDefinition().getMethodOverrides().getOverride(method);
            MethodReplacer mr = this.owner.getBean(ro.getMethodReplacerBeanName(), MethodReplacer.class);
            return mr.reimplement(obj, method, args);
        }
    }

    private static class LookupOverrideMethodInterceptor
    extends CglibIdentitySupport
    implements MethodInterceptor {
        private final BeanFactory owner;

        LookupOverrideMethodInterceptor(RootBeanDefinition beanDefinition, BeanFactory owner) {
            super(beanDefinition);
            this.owner = owner;
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy mp) throws Throwable {
            LookupOverride lo = (LookupOverride)this.getBeanDefinition().getMethodOverrides().getOverride(method);
            return this.owner.getBean(lo.getBeanName());
        }
    }

    private static class MethodOverrideCallbackFilter
    extends CglibIdentitySupport
    implements CallbackFilter {
        private static final Log logger = LogFactory.getLog(MethodOverrideCallbackFilter.class);

        MethodOverrideCallbackFilter(RootBeanDefinition beanDefinition) {
            super(beanDefinition);
        }

        public int accept(Method method) {
            MethodOverride methodOverride = this.getBeanDefinition().getMethodOverrides().getOverride(method);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Override for '" + method.getName() + "' is [" + methodOverride + "]"));
            }
            if (methodOverride == null) {
                return 0;
            }
            if (methodOverride instanceof LookupOverride) {
                return 1;
            }
            if (methodOverride instanceof ReplaceOverride) {
                return 2;
            }
            throw new UnsupportedOperationException("Unexpected MethodOverride subclass: " + methodOverride.getClass().getName());
        }
    }

    private static class CglibIdentitySupport {
        private final RootBeanDefinition beanDefinition;

        CglibIdentitySupport(RootBeanDefinition beanDefinition) {
            this.beanDefinition = beanDefinition;
        }

        RootBeanDefinition getBeanDefinition() {
            return this.beanDefinition;
        }

        public boolean equals(Object other) {
            return other.getClass().equals(this.getClass()) && ((CglibIdentitySupport)other).getBeanDefinition().equals(this.getBeanDefinition());
        }

        public int hashCode() {
            return this.beanDefinition.hashCode();
        }
    }

    private static class CglibSubclassCreator {
        private static final Class<?>[] CALLBACK_TYPES = new Class[]{NoOp.class, LookupOverrideMethodInterceptor.class, ReplaceOverrideMethodInterceptor.class};
        private final RootBeanDefinition beanDefinition;
        private final BeanFactory owner;

        CglibSubclassCreator(RootBeanDefinition beanDefinition, BeanFactory owner) {
            this.beanDefinition = beanDefinition;
            this.owner = owner;
        }

        Object instantiate(Constructor<?> ctor, Object[] args) {
            Object instance;
            Class<?> subclass = this.createEnhancedSubclass(this.beanDefinition);
            if (ctor == null) {
                instance = BeanUtils.instantiate(subclass);
            } else {
                try {
                    Constructor<?> enhancedSubclassConstructor = subclass.getConstructor(ctor.getParameterTypes());
                    instance = enhancedSubclassConstructor.newInstance(args);
                }
                catch (Exception e) {
                    throw new BeanInstantiationException(this.beanDefinition.getBeanClass(), String.format("Failed to invoke construcor for CGLIB enhanced subclass [%s]", subclass.getName()), e);
                }
            }
            Factory factory = (Factory)instance;
            factory.setCallbacks(new Callback[]{NoOp.INSTANCE, new LookupOverrideMethodInterceptor(this.beanDefinition, this.owner), new ReplaceOverrideMethodInterceptor(this.beanDefinition, this.owner)});
            return instance;
        }

        private Class<?> createEnhancedSubclass(RootBeanDefinition beanDefinition) {
            Enhancer enhancer = new Enhancer();
            enhancer.setSuperclass(beanDefinition.getBeanClass());
            enhancer.setNamingPolicy((NamingPolicy)SpringNamingPolicy.INSTANCE);
            enhancer.setCallbackFilter((CallbackFilter)new MethodOverrideCallbackFilter(beanDefinition));
            enhancer.setCallbackTypes((Class[])CALLBACK_TYPES);
            return enhancer.createClass();
        }
    }
}

