/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.tuple;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;
import org.springframework.tuple.Tuple;
import org.springframework.tuple.TupleBuilder;

public class JsonStringToTupleConverter
implements Converter<String, Tuple> {
    private final ObjectMapper mapper = new ObjectMapper();

    public JsonStringToTupleConverter() {
        this.mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
    }

    public Tuple convert(String source) {
        TupleBuilder builder = TupleBuilder.tuple();
        try {
            JsonNode root = this.mapper.readTree(source);
            Iterator it = root.fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                String name = (String)entry.getKey();
                JsonNode node = (JsonNode)entry.getValue();
                if (node.isObject()) {
                    builder.addEntry(name, this.convert(node.toString()));
                    continue;
                }
                if (node.isArray()) {
                    builder.addEntry(name, this.nodeToList(node));
                    continue;
                }
                if (node.isNull()) {
                    builder.addEntry(name, null);
                    continue;
                }
                if (node.isBoolean()) {
                    builder.addEntry(name, node.booleanValue());
                    continue;
                }
                if (node.isNumber()) {
                    builder.addEntry(name, node.numberValue());
                    continue;
                }
                builder.addEntry(name, this.mapper.treeToValue((TreeNode)node, Object.class));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return builder.build();
    }

    private List<Object> nodeToList(JsonNode node) throws JsonProcessingException {
        ArrayList<Object> list = new ArrayList<Object>(node.size());
        for (int i = 0; i < node.size(); ++i) {
            JsonNode item = node.get(i);
            if (item.isObject()) {
                list.add(this.convert(item.toString()));
                continue;
            }
            if (item.isArray()) {
                list.add(this.nodeToList(item));
                continue;
            }
            if (item.isNull()) {
                list.add(null);
                continue;
            }
            if (item.isBoolean()) {
                list.add(item.booleanValue());
                continue;
            }
            if (item.isNumber()) {
                list.add(item.numberValue());
                continue;
            }
            list.add(this.mapper.treeToValue((TreeNode)item, Object.class));
        }
        return list;
    }
}

