/*  Copyright 2004 Ryan Ackley
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.textmining.text.extraction.sprm;

/**
 * This class is used to iterate through a list of sprms from a Word 97/2000/XP
 * document.
 * @author Ryan Ackley
 * @version 1.0
 */

public class SprmIterator
{
  private byte[] _grpprl;
  int _offset;

  public SprmIterator(byte[] grpprl)
  {
    _grpprl = grpprl;
    _offset = 0;
  }

  public boolean hasNext()
  {
    return _offset < _grpprl.length;
  }

  public SprmOperation next()
  {
    SprmOperation op = new SprmOperation(_grpprl, _offset);
    _offset += op.size();
    return op;
  }


}
